unit DelphiUnitReconeixement;

{*******************************************************}
interface
{*******************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    ButtonEntrenament: TButton;
    ButtonReconeixement: TButton;
    ButtonObrir: TButton;
    ButtonGuardar: TButton;
    ButtonParlantDe: TButton;
    ButtonVontrolDeVolum: TButton;
    ButtonFuncionsDOna: TButton;
    Label1: TLabel;
    ButtonVeureElsSons: TButton;
    procedure ButtonFuncionsDOnaClick(Sender: TObject);
    procedure ButtonVontrolDeVolumClick(Sender: TObject);
    procedure ButtonParlantDeClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonEntrenamentClick(Sender: TObject);
    procedure ButtonReconeixementClick(Sender: TObject);
    procedure ButtonObrirClick(Sender: TObject);
    procedure ButtonGuardarClick(Sender: TObject);
    procedure ButtonVeureElsSonsClick(Sender: TObject);
  private
    { Private declarations }
    Sons:array[1..32]of String;
    HeFetLEntrenament:Boolean;
    procedure ParaulaReconeguda(var Msg: TMessage); message wm_User;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

function IniciarUnitReconeixementDeSons(H:HWnd;NP:SmallInt;s:string):SmallInt; stdcall; External 'TotiPMSpeechRecognitionEngine.dll';
function ObrirFitxer:boolean; stdcall; External 'TotiPMSpeechRecognitionEngine.dll';
function RetornarSonsQueSeReconeixer:ShortString; stdcall; External 'TotiPMSpeechRecognitionEngine.dll';
function IniciarEntrenament:SmallInt; stdcall; External 'TotiPMSpeechRecognitionEngine.dll';
function IniciarReconeixement:SmallInt; stdcall; External 'TotiPMSpeechRecognitionEngine.dll';
procedure PararReconeixement; stdcall; External 'TotiPMSpeechRecognitionEngine.dll';
procedure GuardarFitxerReconeixementDeParaules; stdcall; External 'TotiPMSpeechRecognitionEngine.dll';
procedure QuadreAboutBox; stdcall; External 'TotiPMSpeechRecognitionEngine.dll';
procedure VeureFinestraGrafiques; stdcall; External 'TotiPMSpeechRecognitionEngine.dll';
procedure VeureNivellDeSo; stdcall; External 'TotiPMSpeechRecognitionEngine.dll';
function NumeroVersio:single; stdcall; External 'TotiPMSpeechRecognitionEngine.dll';

{*******************************************************}
implementation
{*******************************************************}

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  NumeroDeParaulesAReconeixer:integer;
  NumVer:single;
begin
  NumeroDeParaulesAReconeixer := 7;
  Sons[1] := 'A';
  Sons[2] := 'AE';
  Sons[3] := '';
  Sons[4] := '';
  Sons[5] := 'I';
  Sons[6] := 'O';
  Sons[7] := 'U';

  If IniciarUnitReconeixementDeSons(Handle, NumeroDeParaulesAReconeixer, 'A,AE,,,I,O,U') = 0 Then begin
    ButtonEntrenament.Enabled := True;
    ButtonReconeixement.Enabled := false;
    ButtonGuardar.Enabled := False;
    ButtonObrir.Enabled := True;
    HeFetLEntrenament := False;
    NumVer := NumeroVersio;
  end else begin
    ShowMessage('No s''ha pogut iniciar la Dll de reconeixement de sons');
  end;

end;

procedure TForm1.ParaulaReconeguda(var Msg: TMessage);
var
  ParaulaReconeguda:integer;
begin
  ParaulaReconeguda := Msg.WParam;
  if ParaulaReconeguda = -1 then begin                //S'acaba l'entrenament
    if not HeFetLEntrenament then begin
      ButtonReconeixement.Enabled := True;
      ButtonGuardar.Enabled := True;
      ButtonObrir.Enabled := True;
      HeFetLEntrenament := True;
    end;
  end else if ParaulaReconeguda = 0 then begin        //No hi ha paraula reconeguda
  end else if ParaulaReconeguda > 0 then begin        //Es retorna la paraula reconeguda

    //Aqu s on el vostre programa ha de fer quelcom
    Label1.Caption := Sons[ParaulaReconeguda];

  end;
end;

procedure TForm1.ButtonEntrenamentClick(Sender: TObject);
begin
  ButtonReconeixement.Enabled := False;
  ButtonObrir.Enabled := False;
  ButtonGuardar.Enabled := False;
  Label1.Caption := '';
  IniciarEntrenament;
  HeFetLEntrenament := False;
end;

procedure TForm1.ButtonReconeixementClick(Sender: TObject);
begin
  if ButtonReconeixement.Caption = 'Parar' then begin
    ButtonReconeixement.Caption := 'Reconeixement';
    ButtonEntrenament.Enabled := True;
    ButtonObrir.Enabled := True;
    ButtonGuardar.Enabled := True;
    Label1.Caption := '';
    PararReconeixement;
  end else begin
    if IniciarReconeixement = 0 then begin
      ButtonReconeixement.Caption := 'Parar';
      ButtonEntrenament.Enabled := False;
      ButtonObrir.Enabled := False;
      ButtonGuardar.Enabled := False;
      Label1.Caption := '';
    end;
  end;
end;

procedure TForm1.ButtonObrirClick(Sender: TObject);
begin
  if ObrirFitxer then begin
    ButtonReconeixement.Enabled := True;
    ButtonGuardar.Enabled := True;
  end;
end;

procedure TForm1.ButtonVeureElsSonsClick(Sender: TObject);
begin
  Label1.Caption := RetornarSonsQueSeReconeixer;
end;

procedure TForm1.ButtonGuardarClick(Sender: TObject);
begin
  GuardarFitxerReconeixementDeParaules;
end;

procedure TForm1.ButtonParlantDeClick(Sender: TObject);
begin
  QuadreAboutBox;
end;

procedure TForm1.ButtonVontrolDeVolumClick(Sender: TObject);
begin
  VeureNivellDeSo;
end;

procedure TForm1.ButtonFuncionsDOnaClick(Sender: TObject);
begin
  VeureFinestraGrafiques;
end;

end.
