/*
 * Decompiled with CFR 0.152.
 */
package algebralineal.R3;

import algebralineal.R3.Quaternio;
import algebralineal.R3.vectorR3;
import algebralineal.excepcions.QuaternioZeroException;
import algebralineal.excepcions.VectorZeroException;
import algebralineal.excepcions.VectorsLinealmentDependentsException;

public final class AlgebraR3 {
    public static final vectorR3 v0 = new vectorR3(0.0, 0.0, 0.0);
    public static final vectorR3 vI = new vectorR3(1.0, 0.0, 0.0);
    public static final vectorR3 vJ = new vectorR3(0.0, 1.0, 0.0);
    public static final vectorR3 vK = new vectorR3(0.0, 0.0, 1.0);
    public static final Quaternio q0 = new Quaternio(0.0, 0.0, 0.0, 0.0);
    public static final Quaternio q1 = new Quaternio(1.0, 0.0, 0.0, 0.0);
    public static final Quaternio qI = new Quaternio(0.0, 1.0, 0.0, 0.0);
    public static final Quaternio qJ = new Quaternio(0.0, 0.0, 1.0, 0.0);
    public static final Quaternio qK = new Quaternio(0.0, 0.0, 0.0, 1.0);

    private AlgebraR3() {
    }

    public static vectorR3 lambdaP(double d, vectorR3 vectorR32) {
        return new vectorR3(d * vectorR32.x, d * vectorR32.y, d * vectorR32.z);
    }

    public static vectorR3 PQSuma(vectorR3 vectorR32, vectorR3 vectorR33) {
        return new vectorR3(vectorR32.x + vectorR33.x, vectorR32.y + vectorR33.y, vectorR32.z + vectorR33.z);
    }

    public static vectorR3 PQResta(vectorR3 vectorR32, vectorR3 vectorR33) {
        return new vectorR3(vectorR32.x - vectorR33.x, vectorR32.y - vectorR33.y, vectorR32.z - vectorR33.z);
    }

    public static double PQEscalar(vectorR3 vectorR32, vectorR3 vectorR33) {
        return vectorR32.x * vectorR33.x + vectorR32.y * vectorR33.y + vectorR32.z * vectorR33.z;
    }

    public static double Modul(vectorR3 vectorR32) {
        return Math.sqrt(AlgebraR3.PQEscalar(vectorR32, vectorR32));
    }

    public static vectorR3 unitVector(vectorR3 vectorR32) throws VectorZeroException {
        double d = AlgebraR3.Modul(vectorR32);
        if (d == 0.0) {
            throw new VectorZeroException("Intentes calcular la direcci\u00f3 del vector zero!");
        }
        return AlgebraR3.lambdaP(1.0 / d, vectorR32);
    }

    public static vectorR3 PQVectorial(vectorR3 vectorR32, vectorR3 vectorR33) {
        return new vectorR3(vectorR32.y * vectorR33.z - vectorR32.z * vectorR33.y, vectorR32.z * vectorR33.x - vectorR32.x * vectorR33.z, vectorR32.x * vectorR33.y - vectorR32.y * vectorR33.x);
    }

    public static double DeterminantR3(vectorR3 vectorR32, vectorR3 vectorR33, vectorR3 vectorR34) {
        return AlgebraR3.PQEscalar(AlgebraR3.PQVectorial(vectorR32, vectorR33), vectorR34);
    }

    public static double[] cLineal(vectorR3 vectorR32, vectorR3 vectorR33, vectorR3 vectorR34, vectorR3 vectorR35) throws VectorsLinealmentDependentsException {
        double[] dArray = new double[3];
        double d = AlgebraR3.DeterminantR3(vectorR33, vectorR34, vectorR35);
        if (d == 0.0) {
            throw new VectorsLinealmentDependentsException("Els vectors s\u00f3n linealment dependents!");
        }
        dArray[0] = AlgebraR3.DeterminantR3(vectorR32, vectorR34, vectorR35) / d;
        dArray[1] = AlgebraR3.DeterminantR3(vectorR33, vectorR32, vectorR35) / d;
        dArray[2] = AlgebraR3.DeterminantR3(vectorR33, vectorR34, vectorR32) / d;
        return dArray;
    }

    public static Quaternio vec2quat(vectorR3 vectorR32) {
        return new Quaternio(0.0, vectorR32);
    }

    public static Quaternio Conjugat(Quaternio quaternio) {
        return new Quaternio(quaternio.lEscalar, AlgebraR3.lambdaP(-1.0, quaternio.elVector));
    }

    public static double Modul(Quaternio quaternio) {
        return Math.sqrt(quaternio.lEscalar * quaternio.lEscalar + AlgebraR3.PQEscalar(quaternio.elVector, quaternio.elVector));
    }

    public static Quaternio unitQuaternio(Quaternio quaternio) throws QuaternioZeroException {
        double d = AlgebraR3.Modul(quaternio);
        if (d == 0.0) {
            throw new QuaternioZeroException("Intentes calcular la direcci\u00f3 del quaterni\u00f3 zero!");
        }
        return AlgebraR3.lambdaP(1.0 / d, quaternio);
    }

    public static double Angle(Quaternio quaternio) throws QuaternioZeroException {
        if (quaternio.modul == 0.0) {
            throw new QuaternioZeroException("Aquest quaterni\u00f3 t\u00e9 m\u00f2dul zero!");
        }
        return Math.acos(quaternio.lEscalar / quaternio.modul);
    }

    public static Quaternio Invers(Quaternio quaternio) throws QuaternioZeroException {
        double d = AlgebraR3.Modul(quaternio) * AlgebraR3.Modul(quaternio);
        if (quaternio.modul == 0.0) {
            throw new QuaternioZeroException("Intentes calcular l'invers del quaterni\u00f3 zero!");
        }
        return new Quaternio(quaternio.lEscalar / d, AlgebraR3.lambdaP(-1.0 / d, quaternio.elVector));
    }

    public static Quaternio lambdaP(double d, Quaternio quaternio) {
        return new Quaternio(d * quaternio.lEscalar, AlgebraR3.lambdaP(d, quaternio.elVector));
    }

    public static Quaternio PQSuma(Quaternio quaternio, Quaternio quaternio2) {
        return new Quaternio(quaternio.lEscalar + quaternio2.lEscalar, AlgebraR3.PQSuma(quaternio.elVector, quaternio2.elVector));
    }

    public static Quaternio PQProducte(Quaternio quaternio, Quaternio quaternio2) {
        return new Quaternio(quaternio.lEscalar * quaternio2.lEscalar - AlgebraR3.PQEscalar(quaternio.elVector, quaternio2.elVector), AlgebraR3.PQSuma(AlgebraR3.PQVectorial(quaternio.elVector, quaternio2.elVector), AlgebraR3.PQSuma(AlgebraR3.lambdaP(quaternio2.lEscalar, quaternio.elVector), AlgebraR3.lambdaP(quaternio.lEscalar, quaternio2.elVector))));
    }

    public static vectorR3 qRotacio(vectorR3 vectorR32, Quaternio quaternio) {
        Quaternio quaternio2 = AlgebraR3.vec2quat(vectorR32);
        Quaternio quaternio3 = AlgebraR3.PQProducte(quaternio, AlgebraR3.PQProducte(quaternio2, AlgebraR3.Conjugat(quaternio)));
        return quaternio3.elVector;
    }

    public static vectorR3 qRotacio(vectorR3 vectorR32, vectorR3 vectorR33, Quaternio quaternio) {
        vectorR3 vectorR34 = AlgebraR3.PQResta(vectorR32, vectorR33);
        vectorR3 vectorR35 = AlgebraR3.qRotacio(vectorR34, quaternio);
        return AlgebraR3.PQSuma(vectorR35, vectorR33);
    }

    public static vectorR3 vNormal(vectorR3 vectorR32, vectorR3 vectorR33, vectorR3 vectorR34) throws VectorZeroException {
        return AlgebraR3.unitVector(AlgebraR3.PQVectorial(AlgebraR3.PQResta(vectorR33, vectorR32), AlgebraR3.PQResta(vectorR34, vectorR32)));
    }

    public static vectorR3 vNormal(vectorR3 vectorR32, vectorR3 vectorR33, vectorR3 vectorR34, vectorR3 vectorR35) throws VectorZeroException {
        return AlgebraR3.unitVector(AlgebraR3.PQVectorial(AlgebraR3.PQResta(vectorR34, vectorR32), AlgebraR3.PQResta(vectorR35, vectorR33)));
    }
}

