/*
 * Decompiled with CFR 0.152.
 */
package algebralineal.R3;

import algebralineal.R3.AlgebraR3;
import algebralineal.R3.vectorR3;
import algebralineal.excepcions.QuaternioZeroException;

public class Quaternio {
    public double lEscalar;
    public vectorR3 elVector;
    public double modul;
    public double lAngle;

    public Quaternio() {
        this.lEscalar = 0.0;
        this.elVector = new vectorR3();
        this.modul = 0.0;
        this.lAngle = 0.0;
    }

    public Quaternio(Quaternio quaternio) {
        this.lEscalar = quaternio.lEscalar;
        this.elVector = new vectorR3(quaternio.elVector);
        this.modul = quaternio.modul;
        this.lAngle = quaternio.lAngle;
    }

    public Quaternio(double d, vectorR3 vectorR32) {
        this.lEscalar = d;
        this.elVector = new vectorR3(vectorR32);
        this.modul = AlgebraR3.Modul(this);
        try {
            this.lAngle = AlgebraR3.Angle(this);
            return;
        }
        catch (QuaternioZeroException quaternioZeroException) {
            this.lAngle = 0.0;
            return;
        }
    }

    public Quaternio(double d, double d2, double d3, double d4) {
        this.lEscalar = d;
        this.elVector = new vectorR3(d2, d3, d4);
        this.modul = AlgebraR3.Modul(this);
        try {
            this.lAngle = AlgebraR3.Angle(this);
            return;
        }
        catch (QuaternioZeroException quaternioZeroException) {
            this.lAngle = 0.0;
            return;
        }
    }

    public Quaternio(vectorR3 vectorR32, double d) {
        this.lEscalar = Math.cos(d / 2.0);
        this.elVector = AlgebraR3.lambdaP(Math.sin(d / 2.0) / AlgebraR3.Modul(vectorR32), vectorR32);
        this.modul = AlgebraR3.Modul(this);
        this.lAngle = d;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " (lEscalar=" + this.lEscalar + ",elVector=" + this.elVector.toString() + ") Modul=" + this.modul + ", Angle=" + this.lAngle;
    }
}

