/*
 * Decompiled with CFR 0.152.
 */
package algebralineal.Rn;

import algebralineal.excepcions.MatriuNoQuadradaException;

public class Matriu {
    public double[][] matriu;
    public int numFiles;
    public int numColumnes;
    public int rang;
    public double[][] gauss;
    public boolean esQuadrada;
    public boolean[] generadors;
    private double determinant;
    private double tamanyZero;

    public Matriu(double[][] dArray, double d) {
        this.numFiles = dArray.length;
        this.numColumnes = dArray[0].length;
        this.esQuadrada = this.numFiles == this.numColumnes;
        this.matriu = new double[this.numFiles][this.numColumnes];
        this.gauss = new double[this.numFiles][this.numColumnes];
        this.rang = 0;
        this.determinant = 1.0;
        this.generadors = new boolean[this.numColumnes];
        this.tamanyZero = Math.abs(d);
        int n = 0;
        while (n < this.numColumnes) {
            this.generadors[n] = false;
            int n2 = 0;
            while (n2 < this.numFiles) {
                this.matriu[n2][n] = dArray[n2][n];
                this.gauss[n2][n] = this.esZero(dArray[n2][n]);
                ++n2;
            }
            ++n;
        }
        this.fesGauss();
    }

    public double getDeterminant() throws MatriuNoQuadradaException {
        if (!this.esQuadrada) {
            throw new MatriuNoQuadradaException("La matriu no \u00e9s quadrada!");
        }
        return this.determinant;
    }

    protected void fesGauss() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.numFiles) {
            int n3;
            double d;
            int n4 = n2 + n;
            while (n4 < this.numColumnes) {
                if (n2 + n >= this.numColumnes) break;
                int n5 = this.elementMesGran(n2, n2 + n);
                d = this.gauss[n5][n2 + n];
                if (d != 0.0) {
                    this.intercanviaFiles(n2, n5);
                    this.generadors[n2 + n] = true;
                    ++this.rang;
                    this.determinant = -this.determinant * d;
                    this.gauss[n2][n2 + n] = 1.0;
                    n3 = n2 + n + 1;
                    while (n3 < this.numColumnes) {
                        this.gauss[n2][n3] = this.gauss[n2][n3] / d;
                        ++n3;
                    }
                    break;
                }
                this.determinant = 0.0;
                ++n;
                ++n4;
            }
            if (n2 + n >= this.numColumnes) break;
            n3 = 0;
            while (n3 < this.numFiles) {
                if (n3 != n2) {
                    d = this.gauss[n3][n2 + n];
                    this.gauss[n3][n2 + n] = 0.0;
                    int n6 = n2 + n + 1;
                    while (n6 < this.numColumnes) {
                        this.gauss[n3][n6] = this.gauss[n3][n6] - d * this.gauss[n2][n6];
                        ++n6;
                    }
                }
                ++n3;
            }
            ++n2;
        }
    }

    protected void intercanviaFiles(int n, int n2) {
        int n3 = 0;
        while (n3 < this.numColumnes) {
            double d = this.gauss[n][n3];
            this.gauss[n][n3] = this.gauss[n2][n3];
            this.gauss[n2][n3] = d;
            ++n3;
        }
    }

    protected int elementMesGran(int n, int n2) {
        int n3 = n;
        double d = Math.abs(this.gauss[n][n2]);
        int n4 = n + 1;
        while (n4 < this.numFiles) {
            double d2 = Math.abs(this.gauss[n4][n2]);
            if (d < d2) {
                n3 = n4;
                d = d2;
            }
            ++n4;
        }
        return n3;
    }

    protected double esZero(double d) {
        double d2 = d;
        if (Math.abs(d) < this.tamanyZero) {
            d2 = 0.0;
        }
        return d2;
    }
}

