/*
 * Decompiled with CFR 0.152.
 */
package algebralineal.Rn;

import algebralineal.Rn.AlgebraRn;
import algebralineal.Rn.Matriu;
import algebralineal.excepcions.MatriusNoMultiplicablesException;
import algebralineal.excepcions.MatriusNumFilesDesigualException;
import algebralineal.excepcions.SistemaDeterminatException;
import algebralineal.excepcions.SistemaIncompatibleException;

public class SistemaLineal {
    public double[][] coeficients;
    public int numEquacions;
    public int numIncognites;
    public int rang;
    public int rangAmpliat;
    public boolean esCompatible;
    private Matriu matriu;
    private Matriu matriuHomogeni;
    private boolean esDeterminat;

    public SistemaLineal(double[][] dArray, double d) {
        this.numEquacions = dArray.length;
        this.numIncognites = dArray[0].length - 1;
        double[][] dArray2 = new double[this.numEquacions][this.numIncognites];
        int n = 0;
        while (n < this.numEquacions) {
            int n2 = 0;
            while (n2 < this.numIncognites) {
                dArray2[n][n2] = dArray[n][n2];
                ++n2;
            }
            ++n;
        }
        this.matriu = new Matriu(dArray, d);
        this.coeficients = this.matriu.matriu;
        this.rangAmpliat = this.matriu.rang;
        this.matriuHomogeni = new Matriu(dArray2, d);
        this.rang = this.matriuHomogeni.rang;
        this.esCompatible = this.rang == this.rangAmpliat;
        if (this.rang == this.numIncognites) {
            this.esDeterminat = true;
            return;
        }
        this.esDeterminat = false;
    }

    public SistemaLineal(double[] dArray, double[][] dArray2, double d) {
        int n = dArray2.length;
        this.numIncognites = dArray2[0].length;
        this.rangAmpliat = this.rang = this.numIncognites - n;
        this.esCompatible = true;
        this.esDeterminat = false;
        double[][] dArray3 = new double[1][this.numIncognites];
        dArray3[0] = dArray;
        dArray3 = AlgebraRn.trasposa(dArray3);
        double[][] dArray4 = new double[n][1];
        int n2 = 0;
        while (n2 < n) {
            dArray4[n2][0] = 0.0;
            ++n2;
        }
        try {
            double[][] dArray5 = AlgebraRn.juxtaposaColumnes(dArray2, dArray4);
            SistemaLineal sistemaLineal = new SistemaLineal(dArray5, d);
            try {
                double[][] dArray6 = sistemaLineal.getNucli();
                this.matriuHomogeni = new Matriu(dArray6, d);
                this.numEquacions = dArray6.length;
                try {
                    double[][] dArray7 = AlgebraRn.producte(dArray6, dArray3);
                    try {
                        this.coeficients = AlgebraRn.juxtaposaColumnes(dArray6, dArray7);
                        this.matriu = new Matriu(this.coeficients, d);
                        return;
                    }
                    catch (MatriusNumFilesDesigualException matriusNumFilesDesigualException) {
                        return;
                    }
                }
                catch (MatriusNoMultiplicablesException matriusNoMultiplicablesException) {
                    return;
                }
            }
            catch (SistemaDeterminatException sistemaDeterminatException) {
                return;
            }
        }
        catch (MatriusNumFilesDesigualException matriusNumFilesDesigualException) {
            return;
        }
    }

    public boolean esDeterminat() throws SistemaIncompatibleException {
        if (!this.esCompatible) {
            throw new SistemaIncompatibleException("El sistema \u00e9s incompatible!");
        }
        return this.esDeterminat;
    }

    public double[] getSolucioParticular() throws SistemaIncompatibleException {
        if (!this.esCompatible) {
            throw new SistemaIncompatibleException("El sistema \u00e9s incompatible!");
        }
        double[] dArray = new double[this.numIncognites];
        int n = 0;
        int n2 = 0;
        while (n2 < this.rang) {
            int n3 = n2 + n;
            if (this.matriu.generadors[n3]) {
                dArray[n3] = this.matriu.gauss[n2][this.numIncognites];
            } else {
                dArray[n3] = 0.0;
                ++n;
                --n2;
            }
            ++n2;
        }
        return dArray;
    }

    public double[][] getNucli() throws SistemaDeterminatException {
        if (this.rang == this.numIncognites) {
            throw new SistemaDeterminatException("El sistema \u00e9s determinat!");
        }
        int n = this.numIncognites - this.rang;
        double[][] dArray = new double[n][this.numIncognites];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.numIncognites) {
            int n5 = 0;
            int n6 = 0;
            if (!this.matriu.generadors[n4]) {
                int n7 = 0;
                while (n7 < this.numIncognites) {
                    dArray[n2][n7] = 0.0;
                    ++n7;
                }
                dArray[n2][n4] = -1.0;
                while (n6 < this.rang) {
                    n3 = n6 + n5;
                    if (this.matriu.generadors[n3]) {
                        dArray[n2][n3] = this.matriu.gauss[n6][n4];
                    } else {
                        ++n5;
                        --n6;
                    }
                    ++n6;
                }
                ++n2;
            }
            ++n4;
        }
        return dArray;
    }
}

