/*
 * Decompiled with CFR 0.152.
 */
package mesAWT.geometries;

import algebralineal.excepcions.SistemaDeterminatException;
import algebralineal.excepcions.SistemaIncompatibleException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.util.Observable;
import mesAWT.controls.GrupBotons;
import mesAWT.controls.GrupControlsObservable;
import mesAWT.controls.GrupScrollbars;
import mesAWT.geometries.ControlGeometria3D;
import mesAWT.geometries.RectaParametriques;

class ControlRectaParametriques
extends ControlGeometria3D {
    GrupScrollbars grupScrollbarsColorDireccio;
    GrupBotons grupBotonsDeVeureDireccio;

    public ControlRectaParametriques(RectaParametriques rectaParametriques, String string, boolean bl) {
        super(rectaParametriques, string);
        if (bl) {
            if (this.geometria3D.getVisualitzador3D().esApplet()) {
                ((Component)this).setBounds(0, 0, 270, 196);
            } else {
                ((Component)this).setBounds(0, 0, 270, 160);
            }
            Panel panel = new Panel();
            panel.setBackground(Color.lightGray);
            Color[] colorArray = new Color[]{Color.red, Color.green, Color.blue};
            int[] nArray = new int[]{rectaParametriques.getDireccio().getColor().getRed(), rectaParametriques.getDireccio().getColor().getGreen(), rectaParametriques.getDireccio().getColor().getBlue()};
            this.grupScrollbarsColorDireccio = new GrupScrollbars("grupScrollbarsColorDireccio", 3, 0, null, colorArray, nArray, 1, 0, 255);
            this.grupScrollbarsColorDireccio.addObserver(this);
            panel.add(this.grupScrollbarsColorDireccio);
            this.grupBotonsDeVeureDireccio = new GrupBotons("grupBotonsDeVeureDireccio", 1, 2, true, false, this.geometria3D.getVisualitzador3D().getImatgesGrupBotonsDeVeure());
            this.grupBotonsDeVeureDireccio.addObserver(this);
            panel.add(this.grupBotonsDeVeureDireccio);
            this.add("South", panel);
            Panel panel2 = new Panel();
            ((Component)panel2).setFont(new Font("Arial", 2, 18));
            panel2.setBackground(Color.lightGray);
            panel2.setLayout(new GridLayout(3, 1));
            Label[] labelArray = new Label[3];
            String[] stringArray = new String[]{"    x = ", "    y = ", "    z = "};
            try {
                double[] dArray = ((RectaParametriques)this.geometria3D).getSistemaLineal().getSolucioParticular();
                try {
                    double[] dArray2 = ((RectaParametriques)this.geometria3D).getSistemaLineal().getNucli()[0];
                    int n = 0;
                    while (n < 3) {
                        String string2 = stringArray[n].concat(String.valueOf(ControlGeometria3D.arrodoneix(dArray[n], 2)));
                        double d = ControlGeometria3D.arrodoneix(dArray2[n], 2);
                        if (d != 0.0) {
                            string2 = d > 0.0 ? string2.concat(" + ") : string2.concat(" - ");
                            if (Math.abs(d) != 1.0) {
                                string2 = string2.concat(String.valueOf(Math.abs(d)));
                            }
                            string2 = string2.concat("k");
                        }
                        labelArray[n] = new Label(string2, 0);
                        panel2.add(labelArray[n]);
                        ++n;
                    }
                    this.add("Center", panel2);
                    this.validate();
                    return;
                }
                catch (SistemaDeterminatException sistemaDeterminatException) {
                    return;
                }
            }
            catch (SistemaIncompatibleException sistemaIncompatibleException) {
                return;
            }
        }
    }

    public void update(Observable observable, Object object) {
        RectaParametriques rectaParametriques = (RectaParametriques)this.geometria3D;
        if (observable instanceof GrupControlsObservable) {
            String string = (String)object;
            if (string == "grupScrollbarsColor") {
                Integer[] integerArray = this.grupScrollbarsColor.getValors();
                Color color = new Color(integerArray[0], integerArray[1], integerArray[2]);
                this.geometria3D.setColor(color);
                return;
            }
            if (string == "grupScrollbarsColorDireccio") {
                Integer[] integerArray = this.grupScrollbarsColorDireccio.getValors();
                Color color = new Color(integerArray[0], integerArray[1], integerArray[2]);
                rectaParametriques.getDireccio().setColor(color);
                return;
            }
            if (string == "grupBotonsDeVeure") {
                Boolean[] booleanArray = this.grupBotonsDeVeure.getActius();
                if (booleanArray[0].booleanValue()) {
                    this.geometria3D.setArestes(false);
                } else {
                    this.geometria3D.setArestes(true);
                }
                if (booleanArray[1].booleanValue()) {
                    this.geometria3D.setSuperficie(false);
                    return;
                }
                this.geometria3D.setSuperficie(true);
                return;
            }
            if (string == "grupBotonsDeVeureDireccio") {
                Boolean[] booleanArray = this.grupBotonsDeVeureDireccio.getActius();
                if (booleanArray[0].booleanValue()) {
                    rectaParametriques.getDireccio().setArestes(false);
                } else {
                    rectaParametriques.getDireccio().setArestes(true);
                }
                if (booleanArray[1].booleanValue()) {
                    rectaParametriques.getDireccio().setSuperficie(false);
                    return;
                }
                rectaParametriques.getDireccio().setSuperficie(true);
                return;
            }
            if (string == "grupBotonsKill") {
                this.geometria3D.kill();
            }
        }
    }
}

