/*
 * Decompiled with CFR 0.152.
 */
package mesAWT.geometries;

import algebralineal.Rn.SistemaLineal;
import java.awt.Color;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import mesAWT.geometries.ControlGeometria3D;
import mesAWT.objectes.Cella3D;
import mesAWT.visualitzadors.Visualitzador3D;

public abstract class Geometries3D {
    String nom;
    String nomScreen;
    SistemaLineal sistemaLineal;
    Vector objectes;
    int resolucio;
    Color color;
    boolean ambControl;
    Visualitzador3D visualitzador3D;
    int idioma;
    ControlGeometria3D controlGeometria3D;

    public Geometries3D(String[] stringArray, int n, Color color, boolean bl, Visualitzador3D visualitzador3D) {
        this.resolucio = n;
        this.color = color;
        this.ambControl = bl;
        this.objectes = new Vector();
        this.visualitzador3D = visualitzador3D;
        this.idioma = this.visualitzador3D.getIdioma();
        this.nomScreen = this.nom = stringArray[this.idioma];
        if (this.ambControl) {
            this.setControl();
        }
    }

    public SistemaLineal getSistemaLineal() {
        return this.sistemaLineal;
    }

    private void setControl() {
        this.controlGeometria3D = new ControlGeometria3D(this, this.nom);
    }

    public abstract void calculaObjectes();

    public String getNom() {
        return this.nom;
    }

    public void setNomScreen(String string) {
        this.nomScreen = string;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean getAmbControl() {
        return this.ambControl;
    }

    public void setColor(Color color) {
        this.color = color;
        Enumeration enumeration = this.objectes.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Cella3D)) continue;
            ((Cella3D)e).setColor(color);
        }
        if (this.visualitzador3D != null) {
            this.visualitzador3D.update(this);
        }
    }

    public void setArestes(boolean bl) {
        Enumeration enumeration = this.objectes.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Cella3D)) continue;
            ((Cella3D)e).setArestes(bl);
        }
        if (this.visualitzador3D != null) {
            this.visualitzador3D.update(this);
        }
    }

    public void setSuperficie(boolean bl) {
        Enumeration enumeration = this.objectes.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Cella3D)) continue;
            ((Cella3D)e).setSuperficie(bl);
        }
        if (this.visualitzador3D != null) {
            this.visualitzador3D.update(this);
        }
    }

    public void setVisualitzador3D(Visualitzador3D visualitzador3D) {
        this.visualitzador3D = visualitzador3D;
    }

    public Visualitzador3D getVisualitzador3D() {
        return this.visualitzador3D;
    }

    public void kill() {
        this.visualitzador3D.removeGeometria(this);
        this.controlGeometria3D.dispose();
    }

    public Vector getObjectes() {
        return this.objectes;
    }

    public void showControl() {
        this.controlGeometria3D.show();
    }

    public void hideControl() {
        ((Component)this.controlGeometria3D).setVisible(false);
    }
}

