/*
 * Decompiled with CFR 0.152.
 */
package mesAWT.visualitzadors;

import algebralineal.R3.AlgebraR3;
import algebralineal.R3.Quaternio;
import algebralineal.R3.vectorR3;
import algebralineal.excepcions.QuaternioZeroException;
import algebralineal.excepcions.VectorZeroException;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import mesAWT.geometries.Geometries3D;
import mesAWT.objectes.Cella3D;
import mesAWT.objectes.Puntet3D;
import mesAWT.objectes.Quadrilater3D;
import mesAWT.objectes.Quadrilater3Dlight;
import mesAWT.objectes.Segmentet3D;
import mesAWT.objectes.Segmentet3Dlight;
import mesAWT.objectes.SegmentetFantasma3D;
import mesAWT.objectes.Textet3D;
import mesAWT.visualitzadors.Element2D;
import mesAWT.visualitzadors.Puntet2D;
import mesAWT.visualitzadors.Quadrilater2D;
import mesAWT.visualitzadors.Segmentet2D;
import mesAWT.visualitzadors.SegmentetFantasma2D;
import mesAWT.visualitzadors.Text2D;
import mesAWT.visualitzadors.Visualitzador3D;
import mesAWT.visualitzadors.perspectiva;

class Canvas3D
extends Canvas
implements MouseListener,
MouseMotionListener {
    private Visualitzador3D visualitzador3D;
    private Color color;
    private Image imatgeNoEsVeu;
    private Element2D[] arrayElements2D = new Element2D[0];
    private Vector elements3D;
    private vectorR3 illuminacioInicial;
    private vectorR3 illuminacio;
    private int pixelsXunitat = 180;
    private double screen2eye = 10.0;
    private vectorR3 origin2screenInicial = new vectorR3(0.0, 0.0, 10.0);
    private vectorR3 origin2screen = new vectorR3(0.0, 0.0, 10.0);
    private Quaternio initialRotation;
    private Quaternio currentRotation;
    private int mouseMode;
    public static final int MOUSE_MODE_SPIN = 0;
    public static final int MOUSE_MODE_MOVE = 1;
    public static final int MOUSE_MODE_ZOOM = 2;
    private boolean mouseDown = false;
    Dimension mousePosicioInicial;
    Dimension mousePosicioCentral;
    Dimension mousePosicioFinal;
    boolean arestes = true;
    boolean superficie = true;

    public Canvas3D(Visualitzador3D visualitzador3D, Color color) {
        this.visualitzador3D = visualitzador3D;
        Quaternio quaternio = new Quaternio(1.0, 0.0, 0.0, -1.0);
        Quaternio quaternio2 = new Quaternio(1.0, -1.0, 0.0, 0.0);
        double d = -0.3490658503988659;
        Quaternio quaternio3 = new Quaternio(Math.cos(d / 2.0), 0.0, Math.sin(d / 2.0), 0.0);
        double d2 = 0.2617993877991494;
        Quaternio quaternio4 = new Quaternio(Math.cos(d2 / 2.0), Math.sin(d2 / 2.0), 0.0, 0.0);
        try {
            this.initialRotation = AlgebraR3.unitQuaternio(AlgebraR3.PQProducte(quaternio4, AlgebraR3.PQProducte(quaternio3, AlgebraR3.PQProducte(quaternio2, quaternio))));
        }
        catch (QuaternioZeroException quaternioZeroException) {}
        this.currentRotation = new Quaternio(this.initialRotation);
        try {
            this.illuminacioInicial = AlgebraR3.unitVector(new vectorR3(-1.0, 1.0, -3.0));
        }
        catch (VectorZeroException vectorZeroException) {}
        this.illuminacio = new vectorR3(this.illuminacioInicial);
        this.elements3D = new Vector();
        this.color = color;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setColor(Color color) {
        this.color = color;
        this.repaint();
    }

    public void setArestes(boolean bl) {
        this.arestes = bl;
        this.repaint();
    }

    public void setSuperficie(boolean bl) {
        this.superficie = bl;
        this.repaint();
    }

    public void resetPerspectiva() {
        this.currentRotation = new Quaternio(this.initialRotation);
        this.origin2screen = new vectorR3(this.origin2screenInicial);
        this.illuminacio = new vectorR3(this.illuminacioInicial);
        this.recalculaElements2D();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.color);
        graphics.fill3DRect(0, 0, dimension.width, dimension.height, false);
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.imatgeNoEsVeu == null) {
            this.imatgeNoEsVeu = this.createImage(dimension.width - 4, dimension.height - 4);
        }
        Graphics graphics2 = this.imatgeNoEsVeu.getGraphics();
        graphics2.setColor(this.color);
        graphics2.fillRect(0, 0, dimension.width - 4, dimension.height - 4);
        int n = this.arrayElements2D.length;
        int n2 = 0;
        while (n2 < n) {
            this.arrayElements2D[n2].paint(graphics2, this.arestes, this.superficie);
            ++n2;
        }
        graphics.drawImage(this.imatgeNoEsVeu, 2, 2, this.color, this);
    }

    public void addGeometria(Vector vector) {
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof Cella3D) {
                this.elements3D.addElement(e);
                continue;
            }
            if (!(e instanceof Geometries3D)) continue;
            this.visualitzador3D.addGeometria((Geometries3D)e);
        }
        this.recalculaElements2D();
        this.setCursor(cursor);
    }

    public void removeGeometria(Geometries3D geometries3D) {
        Object object;
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        Enumeration enumeration = geometries3D.getObjectes().elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (object instanceof Cella3D) {
                this.elements3D.removeElement(object);
                continue;
            }
            if (!(object instanceof Geometries3D)) continue;
            this.visualitzador3D.removeGeometria((Geometries3D)object);
        }
        object = new Vector();
        int n = this.arrayElements2D.length;
        int n2 = 0;
        while (n2 < n) {
            Element2D element2D = this.arrayElements2D[n2];
            if (element2D.getGeometria3D() != geometries3D) {
                ((Vector)object).addElement(element2D);
            }
            ++n2;
        }
        geometries3D = null;
        n = ((Vector)object).size();
        this.arrayElements2D = null;
        this.arrayElements2D = new Element2D[n];
        ((Vector)object).copyInto(this.arrayElements2D);
        this.setCursor(cursor);
        System.gc();
        this.repaint();
    }

    public void updateElements2D(Geometries3D geometries3D) {
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        Color color = ((Cella3D)geometries3D.getObjectes().elementAt(0)).getColor();
        boolean bl = ((Cella3D)geometries3D.getObjectes().elementAt(0)).getArestes();
        boolean bl2 = ((Cella3D)geometries3D.getObjectes().elementAt(0)).getSuperficie();
        int n = this.arrayElements2D.length;
        int n2 = 0;
        while (n2 < n) {
            Element2D element2D = this.arrayElements2D[n2];
            if (element2D.getGeometria3D() == geometries3D) {
                element2D.setArestes(bl);
                element2D.setSuperficie(bl2);
                element2D.illuminaElement2D(color);
            }
            ++n2;
        }
        this.repaint();
        this.setCursor(cursor);
    }

    public void recalculaElements2D() {
        Cursor cursor = this.getCursor();
        if (!this.mouseDown) {
            this.setCursor(new Cursor(3));
        }
        Dimension dimension = this.getSize();
        Vector<Element2D> vector = new Vector<Element2D>();
        Enumeration enumeration = this.elements3D.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Cella3D)) continue;
            if (e instanceof Textet3D) {
                vector.addElement(new Text2D((Textet3D)e, this.illuminacio, dimension, this.pixelsXunitat, this.origin2screen, this.currentRotation, this.screen2eye));
            } else if (e instanceof Puntet3D) {
                vector.addElement(new Puntet2D((Puntet3D)e, this.illuminacio, dimension, this.pixelsXunitat, this.origin2screen, this.currentRotation, this.screen2eye));
            }
            if (this.mouseDown) {
                if (e instanceof Quadrilater3Dlight) {
                    vector.addElement(new Quadrilater2D((Quadrilater3Dlight)e, this.illuminacio, dimension, this.pixelsXunitat, this.origin2screen, this.currentRotation, this.screen2eye));
                    continue;
                }
                if (!(e instanceof Segmentet3Dlight)) continue;
                vector.addElement(new Segmentet2D((Segmentet3Dlight)e, this.illuminacio, dimension, this.pixelsXunitat, this.origin2screen, this.currentRotation, this.screen2eye));
                continue;
            }
            if (e instanceof Quadrilater3D) {
                vector.addElement(new Quadrilater2D((Quadrilater3D)e, this.illuminacio, dimension, this.pixelsXunitat, this.origin2screen, this.currentRotation, this.screen2eye));
                continue;
            }
            if (e instanceof SegmentetFantasma3D) {
                vector.addElement(new SegmentetFantasma2D((SegmentetFantasma3D)e, this.illuminacio, dimension, this.pixelsXunitat, this.origin2screen, this.currentRotation, this.screen2eye));
                continue;
            }
            if (!(e instanceof Segmentet3D)) continue;
            vector.addElement(new Segmentet2D((Segmentet3D)e, this.illuminacio, dimension, this.pixelsXunitat, this.origin2screen, this.currentRotation, this.screen2eye));
        }
        int n = vector.size();
        this.arrayElements2D = new Element2D[n];
        vector.copyInto(this.arrayElements2D);
        perspectiva.sort(this.arrayElements2D);
        this.repaint();
        this.setCursor(cursor);
    }

    public void setMouseMode(int n) {
        this.mouseMode = n;
        if (this.mouseMode == 0) {
            this.setCursor(new Cursor(12));
            return;
        }
        if (this.mouseMode == 1) {
            this.setCursor(new Cursor(13));
            return;
        }
        if (this.mouseMode == 2) {
            this.setCursor(new Cursor(8));
        }
    }

    public int getMouseMode() {
        return this.mouseMode;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseDown = true;
        this.mousePosicioInicial = new Dimension(mouseEvent.getX(), mouseEvent.getY());
        this.mousePosicioCentral = new Dimension(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseDown = false;
        this.recalculaElements2D();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mousePosicioFinal = new Dimension(mouseEvent.getX(), mouseEvent.getY());
        Dimension dimension = new Dimension(this.mousePosicioFinal.width - this.mousePosicioInicial.width, this.mousePosicioFinal.height - this.mousePosicioInicial.height);
        if (this.mouseMode == 0) {
            vectorR3 vectorR32 = AlgebraR3.PQVectorial(new vectorR3(-((double)dimension.width) / (double)this.pixelsXunitat, (double)dimension.height / (double)this.pixelsXunitat, 0.0), this.origin2screen);
            Quaternio quaternio = new Quaternio(vectorR32, vectorR32.modul);
            this.currentRotation = AlgebraR3.PQProducte(quaternio, this.currentRotation);
            vectorR32 = AlgebraR3.qRotacio(vectorR32, AlgebraR3.Conjugat(this.initialRotation));
            quaternio = new Quaternio(vectorR32, vectorR32.modul);
            this.illuminacio = AlgebraR3.qRotacio(this.illuminacio, AlgebraR3.Conjugat(quaternio));
            this.recalculaElements2D();
        } else if (this.mouseMode == 1) {
            vectorR3 vectorR33 = new vectorR3(-((double)dimension.width) / (double)this.pixelsXunitat, (double)dimension.height / (double)this.pixelsXunitat, 0.0);
            this.origin2screen = AlgebraR3.PQSuma(vectorR33, this.origin2screen);
            this.recalculaElements2D();
        } else if (this.mouseMode == 2) {
            double d = Math.pow(1.01, dimension.height);
            this.origin2screen = AlgebraR3.lambdaP(d, this.origin2screen);
            this.recalculaElements2D();
        }
        this.mousePosicioInicial = this.mousePosicioFinal;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

