/*
 * Decompiled with CFR 0.152.
 */
package mesAWT.visualitzadors;

import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import mesAWT.controls.GrupBotons;
import mesAWT.controls.GrupControlsObservable;
import mesAWT.controls.GrupScrollbars;
import mesAWT.geometries.Geometries3D;
import mesAWT.visualitzadors.AppletInicial;
import mesAWT.visualitzadors.Canvas3D;
import mesAWT.visualitzadors.Palette;

public class Visualitzador3D
extends Panel
implements Observer,
ItemListener {
    AppletInicial pare;
    boolean pareEsApplet;
    int idioma;
    public Canvas3D canvas3D;
    GrupBotons grupBotonsDeMoure;
    GrupBotons grupBotonsReset;
    GrupBotons grupBotonsDeVeure;
    GrupBotons grupBotonsPalette;
    GrupScrollbars grupScrollbarsColor;
    Vector geometries;
    Choice choiceGeometries;
    Palette palette;
    String[][] labelsImatgesGrupBotonsDeMoure = new String[][]{{"icones/botoSpinPressed.jpg", "icones/botoSpinReleased.jpg"}, {"icones/botoMovePressed.jpg", "icones/botoMoveReleased.jpg"}, {"icones/botoZoomPressed.jpg", "icones/botoZoomReleased.jpg"}};
    String[][] labelsImatgesGrupBotonsReset = new String[][]{{"icones/botoResetPressed.jpg", "icones/botoResetReleased.jpg"}};
    String[][] labelsImatgesGrupBotonsDeVeure = new String[][]{{"icones/botoGridPressed.jpg", "icones/botoGridReleased.jpg"}, {"icones/botoSuperficiePressed.jpg", "icones/botoSuperficieReleased.jpg"}};
    String[][] labelsImatgesGrupBotonsPalette = new String[][]{{"icones/botoPalettePressed.jpg", "icones/botoPaletteReleased.jpg"}};
    Image[][] imatgesGrupBotonsDeMoure = new Image[3][2];
    Image[][] imatgesGrupBotonsReset = new Image[1][2];
    Image[][] imatgesGrupBotonsDeVeure = new Image[2][2];
    Image[][] imatgesGrupBotonsPalette = new Image[1][2];
    String[] miss_objectes = new String[]{"Objectes geom\u00e8trics disponibles:", "Available Geometrical Objects", "Objetos geom\u00e9tricos disponibles:", "Objets g\u00e9om\u00e9triques disponibles:"};
    String[] miss_afegint = new String[]{"Afegint ", "Adding ", "A\u00f1adiendo ", "En ajoutant "};
    String[] miss_suprimint = new String[]{"Suprimint ", "Removing ", "Suprimiendo ", "En suprimant "};

    public Visualitzador3D(AppletInicial appletInicial) {
        int n;
        int n2;
        this.pare = appletInicial;
        this.pareEsApplet = this.pare.getEsApplet();
        this.idioma = this.pare.getIdioma();
        this.geometries = new Vector();
        this.setLayout(new BorderLayout());
        int[] nArray = new int[]{50, 100, 150};
        this.canvas3D = new Canvas3D(this, new Color(nArray[0], nArray[1], nArray[2]));
        this.canvas3D.setMouseMode(0);
        this.add("Center", this.canvas3D);
        Panel panel = new Panel();
        panel.setBackground(Color.lightGray);
        Color[] colorArray = new Color[]{Color.red, Color.green, Color.blue};
        this.grupScrollbarsColor = new GrupScrollbars("grupScrollbarsColor", 3, 0, null, colorArray, nArray, 1, 0, 255);
        this.grupScrollbarsColor.addObserver(this);
        panel.add(this.grupScrollbarsColor);
        int n3 = 0;
        while (n3 < 3) {
            n2 = 0;
            while (n2 < 2) {
                this.imatgesGrupBotonsDeMoure[n3][n2] = this.pare.getImatge(this.labelsImatgesGrupBotonsDeMoure[n3][n2]);
                ++n2;
            }
            ++n3;
        }
        this.grupBotonsDeMoure = new GrupBotons("grupBotonsDeMoure", 1, 3, true, true, this.imatgesGrupBotonsDeMoure);
        this.grupBotonsDeMoure.addObserver(this);
        panel.add(this.grupBotonsDeMoure);
        n2 = 0;
        while (n2 < 2) {
            this.imatgesGrupBotonsReset[0][n2] = this.pare.getImatge(this.labelsImatgesGrupBotonsReset[0][n2]);
            ++n2;
        }
        this.grupBotonsReset = new GrupBotons("grupBotonsReset", 1, 1, false, false, this.imatgesGrupBotonsReset);
        this.grupBotonsReset.addObserver(this);
        panel.add(this.grupBotonsReset);
        int n4 = 0;
        while (n4 < 2) {
            n = 0;
            while (n < 2) {
                this.imatgesGrupBotonsDeVeure[n4][n] = this.pare.getImatge(this.labelsImatgesGrupBotonsDeVeure[n4][n]);
                ++n;
            }
            ++n4;
        }
        this.grupBotonsDeVeure = new GrupBotons("grupBotonsDeVeure", 1, 2, true, false, this.imatgesGrupBotonsDeVeure);
        this.grupBotonsDeVeure.addObserver(this);
        panel.add(this.grupBotonsDeVeure);
        this.choiceGeometries = new Choice();
        this.choiceGeometries.addItem(this.miss_objectes[this.idioma]);
        this.choiceGeometries.addItemListener(this);
        panel.add(this.choiceGeometries);
        n = 0;
        while (n < 2) {
            this.imatgesGrupBotonsPalette[0][n] = this.pare.getImatge(this.labelsImatgesGrupBotonsPalette[0][n]);
            ++n;
        }
        this.grupBotonsPalette = new GrupBotons("grupBotonsPalette", 1, 1, true, false, this.imatgesGrupBotonsPalette);
        this.grupBotonsPalette.addObserver(this);
        panel.add(this.grupBotonsPalette);
        this.add("South", panel);
        this.validate();
        this.palette = new Palette(this);
    }

    public AppletInicial getPare() {
        return this.pare;
    }

    public boolean esApplet() {
        return this.pareEsApplet;
    }

    public int getIdioma() {
        return this.idioma;
    }

    public void update(Geometries3D geometries3D) {
        this.canvas3D.updateElements2D(geometries3D);
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof GrupControlsObservable) {
            String string = (String)object;
            if (string == "grupBotonsDeMoure") {
                Boolean[] booleanArray = this.grupBotonsDeMoure.getActius();
                if (booleanArray[0].booleanValue()) {
                    this.canvas3D.setMouseMode(0);
                    return;
                }
                if (booleanArray[1].booleanValue()) {
                    this.canvas3D.setMouseMode(1);
                    return;
                }
                if (booleanArray[2].booleanValue()) {
                    this.canvas3D.setMouseMode(2);
                    return;
                }
            } else if (string == "grupBotonsReset") {
                Boolean[] booleanArray = this.grupBotonsReset.getActius();
                if (booleanArray[0].booleanValue()) {
                    this.canvas3D.resetPerspectiva();
                    return;
                }
            } else {
                if (string == "grupScrollbarsColor") {
                    Integer[] integerArray = this.grupScrollbarsColor.getValors();
                    Color color = new Color(integerArray[0], integerArray[1], integerArray[2]);
                    this.canvas3D.setColor(color);
                    return;
                }
                if (string == "grupBotonsDeVeure") {
                    Boolean[] booleanArray = this.grupBotonsDeVeure.getActius();
                    if (booleanArray[0].booleanValue()) {
                        this.canvas3D.setArestes(false);
                    } else {
                        this.canvas3D.setArestes(true);
                    }
                    if (booleanArray[1].booleanValue()) {
                        this.canvas3D.setSuperficie(false);
                        return;
                    }
                    this.canvas3D.setSuperficie(true);
                    return;
                }
                if (string == "grupBotonsPalette") {
                    Boolean[] booleanArray = this.grupBotonsPalette.getActius();
                    if (booleanArray[0].booleanValue()) {
                        this.palette.show();
                        return;
                    }
                    ((Component)this.palette).setVisible(false);
                }
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.choiceGeometries.getSelectedIndex();
        if (n > 0) {
            Geometries3D geometries3D = (Geometries3D)this.geometries.elementAt(n - 1);
            geometries3D.showControl();
        }
    }

    public synchronized void addGeometria(Geometries3D geometries3D) {
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        String string = this.miss_afegint[this.idioma];
        string = string.concat(geometries3D.getNom()).concat("...");
        this.choiceGeometries.remove(0);
        this.choiceGeometries.setBackground(Color.red);
        this.choiceGeometries.setForeground(Color.yellow.brighter());
        this.choiceGeometries.insert(string, 0);
        this.canvas3D.addGeometria(geometries3D.getObjectes());
        geometries3D.setVisualitzador3D(this);
        if (geometries3D.getAmbControl()) {
            this.geometries.addElement(geometries3D);
            this.choiceGeometries.addItem(geometries3D.getNom());
        }
        this.choiceGeometries.remove(0);
        this.choiceGeometries.setBackground(Color.white);
        this.choiceGeometries.setForeground(Color.black);
        this.choiceGeometries.insert(this.miss_objectes[this.idioma], 0);
        this.setCursor(cursor);
    }

    public synchronized void removeGeometria(Geometries3D geometries3D) {
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        String string = this.miss_suprimint[this.idioma];
        string = string.concat(geometries3D.getNom()).concat("...");
        this.choiceGeometries.remove(0);
        this.choiceGeometries.setBackground(Color.red);
        this.choiceGeometries.setForeground(Color.yellow.brighter());
        this.choiceGeometries.insert(string, 0);
        if (geometries3D.getAmbControl()) {
            this.geometries.removeElement(geometries3D);
            this.choiceGeometries.remove(geometries3D.getNom());
        }
        this.canvas3D.removeGeometria(geometries3D);
        this.choiceGeometries.remove(0);
        this.choiceGeometries.setBackground(Color.white);
        this.choiceGeometries.setForeground(Color.black);
        this.choiceGeometries.insert(this.miss_objectes[this.idioma], 0);
        this.setCursor(cursor);
    }

    public Image[][] getImatgesGrupBotonsDeVeure() {
        return this.imatgesGrupBotonsDeVeure;
    }
}

