/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.net.URL;

public class HMathFont {
    HersheyFont fontNoms;
    HersheyFont fontIndexs;
    HersheyFont fontSimbols;
    static float normalWidth = 0.6f;
    static float normalHeight = 0.6f;
    static float normalIndexsWidth = 0.3f;
    static float normalIndexsHeight = 0.3f;

    public HMathFont() {
        this.fontNoms = new HersheyFont("fonts/vectors.jhf");
        this.fontIndexs = new HersheyFont("fonts/vectors.jhf");
        this.fontSimbols = new HersheyFont("fonts/mathlow.jhf");
        this.fontNoms.setHorizontalAlignment(0);
        this.fontIndexs.setHorizontalAlignment(0);
        this.fontSimbols.setHorizontalAlignment(0);
        this.fontNoms.setVerticalAlignment(1);
        this.fontIndexs.setVerticalAlignment(1);
        this.fontSimbols.setVerticalAlignment(1);
        this.setNormalWidth();
        this.setNormalHeight();
    }

    public HMathFont(URL uRL) {
        this.fontNoms = new HersheyFont(uRL, "fonts/vectors.jhf");
        this.fontIndexs = new HersheyFont(uRL, "fonts/vectors.jhf");
        this.fontSimbols = new HersheyFont(uRL, "fonts/mathlow.jhf");
        this.fontNoms.setHorizontalAlignment(0);
        this.fontIndexs.setHorizontalAlignment(0);
        this.fontSimbols.setHorizontalAlignment(0);
        this.fontNoms.setVerticalAlignment(1);
        this.fontIndexs.setVerticalAlignment(1);
        this.fontSimbols.setVerticalAlignment(1);
        this.setNormalWidth();
        this.setNormalHeight();
    }

    public void setRotation(double d) {
        double d2 = d;
        if (Math.abs(d) > 1.5707963267948966) {
            d2 = d + Math.PI;
        }
        this.fontNoms.setRotation(-d2 * 180.0 / Math.PI);
    }

    public void setNormalWidth() {
        this.fontNoms.setWidth(normalWidth);
        this.fontIndexs.setWidth(normalIndexsWidth);
        this.fontSimbols.setWidth(normalWidth);
    }

    public void setNormalHeight() {
        this.fontNoms.setHeight(normalHeight);
        this.fontIndexs.setHeight(normalIndexsHeight);
        this.fontSimbols.setHeight(normalHeight);
    }

    public void drawNomVector(MObjecte mObjecte, Graphics graphics) {
        Dimension[] dimensionArray = mObjecte.getPosNom();
        String string = mObjecte.getNom()[0];
        if (string == "components") {
            Dimension dimension = dimensionArray[1];
            this.setRotation(0.0);
            this.fontNoms.setVerticalAlignment(3);
            Rectangle rectangle = this.fontNoms.stringLimit(mObjecte.getNom()[1], dimension.width, dimension.height, graphics);
            this.fontNoms.drawString(mObjecte.getNom()[1], dimension.width, dimension.height, graphics);
            this.fontNoms.setVerticalAlignment(0);
            Rectangle rectangle2 = this.fontNoms.stringLimit(mObjecte.getNom()[2], dimension.width, dimension.height, graphics);
            this.fontNoms.drawString(mObjecte.getNom()[2], dimension.width, dimension.height, graphics);
            this.fontNoms.setVerticalAlignment(1);
            int n = Math.max(rectangle.width, rectangle2.width) / 2;
            this.fontSimbols.setHorizontalAlignment(2);
            this.fontSimbols.drawString("r", dimension.width - n, dimension.height, graphics);
            this.fontSimbols.setHorizontalAlignment(1);
            this.fontSimbols.drawString("s", dimension.width + n, dimension.height, graphics);
            this.fontSimbols.setHorizontalAlignment(0);
            return;
        }
        if (string == "subindex" || string == "superindex") {
            Dimension dimension = dimensionArray[0];
            this.setRotation(0.0);
            this.fontNoms.setHorizontalAlignment(2);
            if (string == "subindex") {
                this.fontIndexs.setVerticalAlignment(0);
            } else {
                this.fontIndexs.setVerticalAlignment(3);
            }
            this.fontIndexs.setHorizontalAlignment(1);
            Rectangle rectangle = this.fontNoms.stringLimit(mObjecte.getNom()[1], dimension.width, dimension.height, graphics);
            int n = rectangle.width / 2;
            this.fontNoms.drawString(mObjecte.getNom()[1], dimension.width, dimension.height, graphics);
            this.fontIndexs.drawString(mObjecte.getNom()[2], dimension.width, dimension.height, graphics);
            this.fontNoms.setHorizontalAlignment(1);
            rectangle = this.fontIndexs.stringLimit(mObjecte.getNom()[2], dimension.width, dimension.height, graphics);
            n = rectangle.width;
            this.fontNoms.drawString(mObjecte.getNom()[3], dimension.width + n, dimension.height, graphics);
            this.fontNoms.setHorizontalAlignment(0);
            return;
        }
        Dimension dimension = dimensionArray[0];
        if (mObjecte instanceof MVector) {
            this.setRotation(((MVector)mObjecte).getArgument());
        } else {
            this.setRotation(0.0);
        }
        this.fontNoms.drawString(string, dimension.width, dimension.height, graphics);
    }

    public void drawNomVector(String string, int n, int n2, double d, Graphics graphics) {
        this.setRotation(d);
        this.fontNoms.drawString(string, n, n2, graphics);
    }
}

