/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class HersheyFont {
    public static final int HORIZONTAL_CENTER = 0;
    public static final int HORIZONTAL_LEFT = 1;
    public static final int HORIZONTAL_RIGHT = 2;
    public static final int HORIZONTAL_NORMAL = 1;
    public static final int VERTICAL_TOP = 0;
    public static final int VERTICAL_HALF = 1;
    public static final int VERTICAL_CAP = 2;
    public static final int VERTICAL_BOTTOM = 3;
    public static final int VERTICAL_NORMAL = 3;
    private static final int MAX_CHARACTERS = 256;
    private static final int MAX_POINTS = 150;
    protected static final int X = 0;
    protected static final int Y = 1;
    private float hersheyWidth = 1.0f;
    private float hersheyHeight = 1.0f;
    private int hersheyLineWidth = 1;
    private int hersheyHorizontalAlignment = 1;
    private int herhseyVerticalAlignment = 3;
    private double hersheyTheta;
    private boolean hersheyItalics = false;
    private float hersheyItalicSlant = 0.75f;
    private String copyright = "Copyright (c) James P. Buzbee Mar 30, 1996";
    protected String name;
    protected char[][][] characterVectors = new char[256][2][150];
    protected int[] numberOfPoints = new int[256];
    protected int[] characterMinX;
    protected int[] characterMaxX;
    protected int characterSetMinY;
    protected int characterSetMaxY;
    protected int charactersInSet;

    private int getInt(InputStream inputStream, int n) throws IOException {
        int n2 = 0;
        char[] cArray = new char[n];
        int n3 = 0;
        while (n3 < n) {
            int n4 = inputStream.read();
            while (n4 == 10 || n4 == 13) {
                n4 = inputStream.read();
            }
            if (n4 == -1) {
                return n4;
            }
            if ((char)n4 != ' ') {
                cArray[n2++] = (char)n4;
            }
            ++n3;
        }
        return Integer.parseInt(String.copyValueOf(cArray, 0, n2));
    }

    public HersheyFont(String string) {
        this.name = string;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.LoadHersheyFont(string, fileInputStream);
            ((InputStream)fileInputStream).close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException);
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return;
        }
    }

    public HersheyFont(URL uRL, String string) {
        this.name = string;
        try {
            InputStream inputStream = new URL(uRL, string).openStream();
            this.LoadHersheyFont(string, inputStream);
            inputStream.close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException);
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return;
        }
    }

    public HersheyFont(URL uRL) {
        this.name = uRL.toString();
        try {
            InputStream inputStream = uRL.openStream();
            this.LoadHersheyFont(this.name, inputStream);
            inputStream.close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException);
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return;
        }
    }

    private void LoadHersheyFont(String string, InputStream inputStream) {
        int n = this.fontAdjustment(string);
        try {
            int n2;
            int n3 = 0;
            while (true) {
                int n4;
                if (this.getInt(inputStream, 5) < 1) break;
                this.numberOfPoints[n3] = n4 = this.getInt(inputStream, 3);
                n2 = 0;
                while (n2 < n4) {
                    int n5;
                    if (n2 == 32 || n2 == 68 || n2 == 104 || n2 == 140) {
                        inputStream.read();
                    }
                    if ((n5 = inputStream.read()) == 10) {
                        n5 = inputStream.read();
                    }
                    this.characterVectors[n3][0][n2] = (char)n5;
                    this.characterVectors[n3][1][n2] = (char)inputStream.read();
                    ++n2;
                }
                inputStream.read();
                ++n3;
            }
            this.charactersInSet = n3;
            this.characterMinX = new int[this.charactersInSet];
            this.characterMaxX = new int[this.charactersInSet];
            this.characterSetMinY = 1000;
            this.characterSetMaxY = -1000;
            n2 = 1;
            while (n2 < this.charactersInSet) {
                this.calculateCharacterSize(n2, n);
                ++n2;
            }
            if (this.charactersInSet >= 65) {
                this.characterMinX[0] = this.characterMinX[65];
                this.characterMaxX[0] = this.characterMaxX[65];
                return;
            }
            this.characterMinX[0] = this.characterMinX[this.charactersInSet - 1];
            this.characterMaxX[0] = this.characterMaxX[this.charactersInSet - 1];
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return;
        }
    }

    protected void calculateCharacterSize(int n, int n2) {
        this.characterMinX[n] = 1000;
        this.characterMaxX[n] = -1000;
        int n3 = 1;
        while (n3 < this.numberOfPoints[n]) {
            if (this.characterVectors[n][0][n3] != ' ') {
                if (this.characterVectors[n][0][n3] < this.characterMinX[n]) {
                    this.characterMinX[n] = this.characterVectors[n][0][n3];
                }
                if (this.characterVectors[n][0][n3] > this.characterMaxX[n]) {
                    this.characterMaxX[n] = this.characterVectors[n][0][n3];
                }
                if (this.characterVectors[n][1][n3] < this.characterSetMinY) {
                    this.characterSetMinY = this.characterVectors[n][1][n3];
                }
                if (this.characterVectors[n][1][n3] > this.characterSetMaxY) {
                    this.characterSetMaxY = this.characterVectors[n][1][n3];
                }
            }
            ++n3;
        }
        int n4 = n;
        this.characterMinX[n4] = this.characterMinX[n4] - n2;
        int n5 = n;
        this.characterMaxX[n5] = this.characterMaxX[n5] + n2;
    }

    public void drawString(String string, int n, int n2, Graphics graphics) {
        this.drawText(string, n, n2, this.hersheyWidth, this.hersheyHeight, this.hersheyHorizontalAlignment, this.herhseyVerticalAlignment, this.hersheyTheta, true, new Rectangle(), graphics);
    }

    public Rectangle stringLimit(String string, int n, int n2, Graphics graphics) {
        Rectangle rectangle = new Rectangle();
        this.drawText(string, n, n2, this.hersheyWidth, this.hersheyHeight, this.hersheyHorizontalAlignment, this.herhseyVerticalAlignment, this.hersheyTheta, false, rectangle, graphics);
        rectangle.width = rectangle.width - rectangle.x + 1;
        rectangle.height = rectangle.height - rectangle.y + 1;
        return rectangle;
    }

    public void setRotation(double d) {
        this.hersheyTheta = d;
    }

    public void setWidth(float f) {
        this.hersheyWidth = f;
    }

    public void setHeight(float f) {
        this.hersheyHeight = f;
    }

    public void setVerticalAlignment(int n) {
        this.herhseyVerticalAlignment = n;
    }

    public void setHorizontalAlignment(int n) {
        this.hersheyHorizontalAlignment = n;
    }

    public void setItalics(boolean bl) {
        this.hersheyItalics = bl;
    }

    public void setItalicsSlant(float f) {
        this.hersheyItalicSlant = f;
    }

    public void setLineWidth(int n) {
        this.hersheyLineWidth = n;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    protected int drawText(String string, int n, int n2, float f, float f2, int n3, int n4, double d, boolean bl, Rectangle rectangle, Graphics graphics) {
        int n5;
        int n6;
        int n7 = 0;
        int n8 = 0;
        boolean bl2 = false;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        boolean bl3 = bl2 = d != 0.0;
        if (bl2) {
            d = -Math.PI / 180 * d;
            f3 = (float)Math.cos(d);
            f4 = (float)Math.sin(d);
            n7 = n;
            n8 = n2;
        }
        int n9 = n;
        int n10 = n2;
        if (!bl) {
            rectangle.x = n9;
            rectangle.y = n10;
            rectangle.width = n9;
            rectangle.height = n10;
        }
        switch (n4) {
            case 0: {
                f5 = 0.0f;
                break;
            }
            case 1: {
                f5 = 0.5f;
                break;
            }
            case 3: {
                f5 = 1.0f;
                break;
            }
            case 2: {
                f5 = 0.25f;
                break;
            }
        }
        n10 -= (int)(f5 * (f2 * (float)(this.characterSetMaxY - this.characterSetMinY)));
        if (n3 != 1 && n3 != 1) {
            int n11 = 0;
            n6 = 0;
            while (n6 < string.length()) {
                n5 = string.charAt(n6) - 32;
                n11 = (int)((float)n11 + (float)(this.characterMaxX[n5] - this.characterMinX[n5]) * f);
                ++n6;
            }
            n9 = n3 == 0 ? (n9 -= n11 / 2) : (n9 -= n11);
        }
        n6 = 0;
        while (n6 < string.length()) {
            n5 = string.charAt(n6) - 32;
            this.drawCharacter(n9, n10, n7, n8, f, f2, bl2, f4, f3, bl, rectangle, this.characterVectors[n5], this.numberOfPoints[n5], this.characterMinX[n5], this.characterSetMinY, this.hersheyItalics, this.hersheyItalicSlant, graphics);
            n9 += (int)((float)(this.characterMaxX[n5] - this.characterMinX[n5]) * f);
            ++n6;
        }
        return 0;
    }

    protected void drawFontLine(int n, int n2, int n3, int n4, int n5, Graphics graphics) {
        if (n5 > 1) {
            Polygon polygon = new Polygon();
            int n6 = n5 / 2;
            polygon.addPoint(n - n6, n2 + n6);
            polygon.addPoint(n + n6, n2 - n6);
            polygon.addPoint(n3 + n6, n4 - n6);
            polygon.addPoint(n3 - n6, n4 + n6);
            graphics.fillPolygon(polygon);
            return;
        }
        graphics.drawLine(n, n2, n3, n4);
    }

    protected int fontAdjustment(String string) {
        int n = 0;
        if (string.indexOf("scri") < 0) {
            n = string.indexOf("goth") >= 0 ? 2 : 3;
        }
        return n;
    }

    protected void drawCharacter(int n, int n2, int n3, int n4, float f, float f2, boolean bl, float f3, float f4, boolean bl2, Rectangle rectangle, char[][] cArray, int n5, int n6, int n7, boolean bl3, float f5, Graphics graphics) {
        int n8 = 0;
        int n9 = 0;
        boolean bl4 = true;
        float f6 = f2 * -f5;
        int n10 = 1;
        while (n10 < n5) {
            if (cArray[0][n10] == ' ') {
                bl4 = true;
            } else {
                int n11 = (int)(bl3 ? (float)(cArray[1][n10] - n7) * f6 : 0.0f) + this.transformX(n, cArray[0][n10], n6, f);
                int n12 = this.transformY(n2, cArray[1][n10], n7, f2);
                if (bl) {
                    float f7 = n11 - n3;
                    float f8 = n12 - n4;
                    float f9 = f7 * f4 - f8 * f3;
                    float f10 = f7 * f3 + f8 * f4;
                    n11 = (int)((double)f9 + 0.5) + n3;
                    n12 = (int)((double)f10 + 0.5) + n4;
                }
                if (!bl2) {
                    if (n11 < rectangle.x) {
                        rectangle.x = n11;
                    }
                    if (n12 < rectangle.y) {
                        rectangle.y = n12;
                    }
                    if (n11 > rectangle.width) {
                        rectangle.width = n11;
                    }
                    if (n12 > rectangle.height) {
                        rectangle.height = n12;
                    }
                }
                if (!bl4 && bl2) {
                    this.drawFontLine(n8, n9, n11, n12, this.hersheyLineWidth, graphics);
                }
                bl4 = false;
                n8 = n11;
                n9 = n12;
            }
            ++n10;
        }
    }

    protected final int transformX(int n, int n2, int n3, float f) {
        return (int)((float)n + (float)(n2 - n3) * f);
    }

    protected final int transformY(int n, int n2, int n3, float f) {
        return (int)((float)n + (float)(n2 - n3) * f);
    }
}

