/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package org.milaifontanals.app;

import org.milaifontanals.bdr.CpJdbcEmpresa;
import org.milaifontanals.bdr.CpJdbcEmpresaException;
import org.milaifontanals.empresa.Departament;

/**
 *
 * @author Usuari
 */
public class Programa {

    public static void main(String[] args) {
        if (args.length > 1) {
            System.out.println("Error en posar en marxa el programa.");
            System.out.println("Necessita cap paràmetre o el nom del fitxer de propietats");
            System.exit(1);
        }

        CpJdbcEmpresa cp = null;
        try {
            if (args.length == 0) {
                cp = new CpJdbcEmpresa();
            } else {
                cp = new CpJdbcEmpresa(args[0]);
            }
            System.out.println("S'ha establert la connexió");
        } catch (CpJdbcEmpresaException ex) {
            System.out.println("No s'ha pogut crear l'objecte capa de persistència");
            infoError(ex);
            System.exit(1);
        }
        // Comprovar els diversos mètodes desenvolupats a la capa

        // Mètode existeixDepartament
        System.out.println("\n\nComprovació de mètode existeixDepartament");
        int t1[] = {10, 15, 299, -1};
        for (int codi : t1) {
            try {
                System.out.println("Existeix departament " + codi + "? " + cp.existeixDepartament(codi));
            } catch (Exception ex) {
                System.out.println("Error en comprovar existència de departament " + codi);
                infoError(ex);
            }
        }

        // Mètode ObtenirDepartament
        System.out.println("\n\nComprovació de mètode obtenirDepartament");
        for (int codi : t1) {
            try {
                Departament d = cp.obtenirDepartament(codi);
                if (d==null) {
                    System.out.println("No existeix departament de codi "+codi);
                } else {
                    System.out.println("Departament de codi "+ codi + ": " + d);
                }
            } catch (Exception ex) {
                System.out.println("Error en comprovar existència de departament " + codi);
                infoError(ex);
            }
        }

        // Mètode InserirDepartament
        System.out.println("\n\nComprovació de mètode inserirDepartament");
        Departament t2[] = {
            new Departament(70,"Dept 70", "Loc 70"),
            new Departament(10,"Dept 10", "Honolulu"),
            new Departament(50, "FESTES", "Igualada"),
            new Departament( 60, "VENDES", "Jorba")
        };
        for (Departament d : t2) {
            try {
                cp.inserirDepartament(d);
                System.out.println("Departament " + d + " inserit");
                cp.validarCanvis();
                System.out.println("Canvi validat");
            } catch (Exception ex) {
                System.out.println("Error en inserir departament " + d);
                infoError(ex);
            }
        }
        
        // Mèetode tancar capa
        System.out.println("\n\nComprovació de mètode tancarCapa");
        try {
            cp.tancarCapa();
            System.out.println("S'ha tancat la capa de persistència");
        } catch (CpJdbcEmpresaException ex) {
            System.out.println("Error en tancar la capa de persistència");
            infoError(ex);
        }
    }

    private static void infoError(Throwable aux) {
        do {
            if (aux.getMessage() != null) {
                System.out.println("\t" + aux.getMessage());
            }
            aux = aux.getCause();
        } while (aux != null);
    }

}
