/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package org.milaifontanals.app;

import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.milaifontanals.bdr.CpJdbcEmpresa;
import org.milaifontanals.bdr.CpJdbcEmpresaException;
import org.milaifontanals.empresa.Departament;
import org.milaifontanals.empresa.Empleat;

/**
 *
 * @author Usuari
 */
public class Programa {

    public static void main(String[] args) {
        if (args.length > 1) {
            System.out.println("Error en posar en marxa el programa.");
            System.out.println("Necessita cap paràmetre o el nom del fitxer de propietats");
            System.exit(1);
        }

        CpJdbcEmpresa cp = null;
        try {
            if (args.length == 0) {
                cp = new CpJdbcEmpresa();
            } else {
                cp = new CpJdbcEmpresa(args[0]);
            }
            System.out.println("S'ha establert la connexió");
        } catch (CpJdbcEmpresaException ex) {
            System.out.println("No s'ha pogut crear l'objecte capa de persistència");
            infoError(ex);
            System.exit(1);
        }
        // Comprovar els diversos mètodes desenvolupats a la capa

        // Mètode existeixDepartament
        System.out.println("\n\nComprovació de mètode existeixDepartament");
        int t1[] = {10, 15, 299, -1};
        for (int codi : t1) {
            try {
                System.out.println("Existeix departament " + codi + "? " + cp.existeixDepartament(codi));
            } catch (Exception ex) {
                System.out.println("Error en comprovar existència de departament " + codi);
                infoError(ex);
            }
        }

        // Mètode obtenirDepartament
        System.out.println("\n\nComprovació de mètode obtenirDepartament");
        for (int codi : t1) {
            try {
                Departament d = cp.obtenirDepartament(codi);
                if (d == null) {
                    System.out.println("No existeix departament de codi " + codi);
                } else {
                    System.out.println("Departament de codi " + codi + ": " + d);
                }
            } catch (Exception ex) {
                System.out.println("Error en recuperar departament " + codi);
                infoError(ex);
            }
        }

        // Mètode inserirDepartament
        System.out.println("\n\nComprovació de mètode inserirDepartament");
        char resposta = preguntaSiNo("Voleu fer commit després de cada inserció correcta?");

        Departament t2[]
                = {
                    new Departament(70, "Dept 70", "Loc 70"),
                    new Departament(10, "Dept 10", "Honolulu"),
                    new Departament(50, "FESTES", "Igualada"),
                    new Departament(60, "VENDES", "Jorba")
                };
        for (Departament d : t2) {
            try {
                cp.inserirDepartament(d);
                System.out.println("Departament " + d + " inserit");
                if (resposta == 'S') {
                    cp.validarCanvis();
                    System.out.println("Canvi validat");
                }
            } catch (Exception ex) {
                System.out.println("Error en inserir departament " + d);
                infoError(ex);
            }
        }

        // Mètode existeixEmpleat
        System.out.println("\n\nComprovació de mètode existeixEmpleat");
        int t3[] = {-1000, 9999, 7369, 7839};
        for (int codi : t3) {
            try {
                System.out.println("Existeix empleat " + codi + "? " + cp.existeixEmpleat(codi));
            } catch (Exception ex) {
                System.out.println("Error en comprovar existència d'empleat " + codi);
                infoError(ex);
            }
        }

        // Mètode obtenirEmpleat
        System.out.println("\n\nComprovació de mètode obtenirEmpleat");
        for (int codi : t3) {
            try {
                System.out.println("Intent d'obtenir empleat de codi " + codi);
                Empleat e = cp.obtenirEmpleat(codi);
                if (e == null) {
                    System.out.println("\tNo existeix empleat de codi " + codi);
                } else {
                    System.out.println("\tEmpleat de codi " + codi + ": " + e);
                }
            } catch (Exception ex) {
                System.out.println("Error en recuperar empleat " + codi);
                infoError(ex);
            }
        }

        // Mètode inserirEmpleat
        System.out.println("\n\nComprovació de mètode inserirEmpleat");
        resposta = preguntaSiNo("Voleu fer commit després de cada inserció correcta?");

        Departament d10 = null;
        try {
            d10 = cp.obtenirDepartament(10);
        } catch (CpJdbcEmpresaException ex) {
        }
        Departament d99 = new Departament(99, "Dept 99", null);
        Empleat e1000 = new Empleat(1000, "Emp 1000", "FORMADOR", new GregorianCalendar(), null, null, null, null);
        Empleat e7900 = new Empleat(7900, "Emp 7900", null, null, null, null, null, null);
        Empleat e2000 = new Empleat(2000, "Emp 2000", null, null, null, null, e1000, null);
        Empleat e3000 = new Empleat(3000, "Emp 3000", null, null, null, null, null, d10);
        Empleat e4000 = new Empleat(4000, "Emp 4000", null, null, null, null, null, d99);
        Empleat t4[] = {e1000, e7900, e2000, e3000, e4000};
        for (Empleat e : t4) {
            try {
                cp.inserirEmpleat(e);
                System.out.println("Empleat " + e + " inserit");
                if (resposta == 'S') {
                    cp.validarCanvis();
                    System.out.println("Canvi validat");
                }
            } catch (Exception ex) {
                System.out.println("Error en inserir empleat " + e);
                infoError(ex);
            }
        }

        // Mèetode tancar capa
        System.out.println("\n\nComprovació de mètode tancarCapa");
        try {
            cp.tancarCapa();
            System.out.println("S'ha tancat la capa de persistència");
        } catch (CpJdbcEmpresaException ex) {
            System.out.println("Error en tancar la capa de persistència");
            infoError(ex);
        }
    }

    private static void infoError(Throwable aux) {
        do {
            if (aux.getMessage() != null) {
                System.out.println("\t" + aux.getMessage());
            }
            aux = aux.getCause();
        } while (aux != null);
    }

    private static char preguntaSiNo(String missatge) {
        Scanner sc = new Scanner(System.in);
        char sino = ' ';
        do {
            System.out.println(missatge);
            try {
                String resposta = sc.nextLine();
                sino = Character.toUpperCase(resposta.charAt(0));
                if (sino != 'S' && sino != 'N') {
                    throw new NoSuchElementException();
                }
            } catch (NoSuchElementException ex) {
                System.out.println("Cal introduir resposta (S/N)");
            }
        } while (sino != 'S' && sino != 'N');
        return sino;
    }

}
