/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package org.milaifontanals;

import java.io.FileInputStream;
import java.sql.*;
import java.util.Properties;

/**
 * Programa per treballar amb esquema/BD "empresa" en un SGBDR.
 * Necessita un fitxer de configuració (.properties) 
 * gestionat per la class Properties, amb les propietats: url, user, pwd.
 * El nom del fitxer de configuració s'ha de passar per paràmetre en
 * posar en marxa el programa i, si no s'especifica, cal cercar
 * un fitxer de nom "dadesConnexió.properties"
 * @author Usuari
 */
public class Connexio {

    public static void main(String[] args) {
        
        if (args.length>1) {
            System.out.println("El programa cal executar-lo amb 1 paràmetre (nom del fitxer de configuració) o cap paràmetre");
            return;
        }
        String nomFitxer;
        if (args.length==0) {
            nomFitxer = "dadesConnexió.properties";
        } else {
            nomFitxer = args[0];
        }

        Properties p = new Properties();
        try {
            p.load(new FileInputStream(nomFitxer));
        } catch (Exception ex) {
            System.out.println("Error en carregar fitxer de propietats:");
            System.out.println("+Info: " + ex.getMessage());
            return;
        }
        
        String url, user, pwd;
        url = p.getProperty("url");
        user = p.getProperty("user");
        pwd = p.getProperty("pwd");
        // Es podria fer comprovacions de NOT NULL
        
        Connection c = null;
        try {
            c = DriverManager.getConnection(url,user,pwd);
            System.out.println("Connexió establerta!");
            System.out.println("Classe Connection implementada: " + c.getClass().getName());
            
            System.out.println("Autocommit activat? "+c.getAutoCommit());
            
            // Interessa sempre tenir autocommit desactivat:
            c.setAutoCommit(false);
            System.out.println("Després de desactivar-lo, autocommit activat? "+c.getAutoCommit());
  
            
            
            
            
            
            // Feines de gestió de dades dins la BD
        } catch (SQLException ex) {
            System.out.println("Error: " + ex.getMessage());
        } finally {
            try {
                if (c != null) {
                    c.close();
                    System.out.println("Connexió tancada!");
                }
            } catch (SQLException ex) {
                System.out.println("Error en tancar la connexió: " + ex.getMessage());
            }
        }
    }
}
