/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package org.milaifontanals;

import java.io.FileInputStream;
import java.sql.*;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Programa per treballar amb esquema/BD "empresa" en un SGBDR. Necessita un
 * fitxer de configuració (.properties) gestionat per la class Properties, amb
 * les propietats: url, user, pwd. El nom del fitxer de configuració s'ha de
 * passar per paràmetre en posar en marxa el programa i, si no s'especifica, cal
 * cercar un fitxer de nom "dadesConnexió.properties"
 *
 * @author Usuari
 */
public class ProvesEmpresa {

    private static Connection c;

    public static void main(String[] args) {

        if (args.length > 1) {
            System.out.println("El programa cal executar-lo amb 1 paràmetre (nom del fitxer de configuració) o cap paràmetre");
            return;
        }
        String nomFitxer;
        if (args.length == 0) {
            nomFitxer = "dadesConnexió.properties";
        } else {
            nomFitxer = args[0];
        }

        Properties p = new Properties();
        try {
            p.load(new FileInputStream(nomFitxer));
        } catch (Exception ex) {
            System.out.println("Error en carregar fitxer de propietats:");
            System.out.println("+Info: " + ex.getMessage());
            return;
        }

        String url, user, pwd;
        url = p.getProperty("url");
        user = p.getProperty("user");
        pwd = p.getProperty("pwd");
        // Es podria fer comprovacions de NOT NULL

        c = null;
        try {
            c = DriverManager.getConnection(url, user, pwd);
            System.out.println("Connexió establerta!");
            System.out.println("Classe Connection implementada: " + c.getClass().getName());

            System.out.println("Autocommit activat? " + c.getAutoCommit());

            // Interessa sempre tenir autocommit desactivat:
            c.setAutoCommit(false);
            System.out.println("Després de desactivar-lo, autocommit activat? " + c.getAutoCommit());

            mostrarEmpleats();

            // Feines de gestió de dades dins la BD
        } catch (SQLException ex) {
            System.out.println("Error: " + ex.getMessage());
        } finally {
            try {
                if (c != null) {
                    c.close();
                    System.out.println("Connexió tancada!");
                }
            } catch (SQLException ex) {
                System.out.println("Error en tancar la connexió: " + ex.getMessage());
            }
        }
    }

    private static void mostrarEmpleats() {
        try {
            PreparedStatement ps = c.prepareStatement(
                    "select e1.emp_no, e1.cognom, e1.ofici, e1.data_alta, e1.salari, e1.comissio,\n"
                    + "    e2.cognom as \"cognom_cap\", d.dnom\n"
                    + "from emp e1 left join emp e2 on e1.cap = e2.emp_no\n"
                    + "            join dept d on e1.dept_no = d.dept_no");
            ResultSet rs = ps.executeQuery();
            boolean trobat = false;
            while (rs.next()) {
                if (!trobat) {
                    System.out.println("Relació d'empleats:");
                    trobat = true;
                }
                int codi = rs.getInt("emp_no");
                String cognom = rs.getString("cognom");
                String ofici = rs.getString("ofici");
                String cap = rs.getString("cognom_cap");
                Date alta = rs.getDate("data_alta");
                Long salari = rs.getLong("salari");
                if (rs.wasNull()) {
                    salari = null;
                }
                Long comissio = rs.getLong("comissio");
                if (rs.wasNull()) {
                    comissio = null;
                }
                String dept = rs.getString("dnom");

                System.out.println();
                System.out.println("Codi: " + codi);
                System.out.println("Cognom: " + cognom);
                System.out.println("Ofici: " + (ofici == null ? "???" : ofici));
                System.out.println("Cap: " +  (cap == null ? "???" : cap));
                System.out.println("Data alta: " +  (alta == null ? "???" : alta));
                System.out.println("Salari: " +  (salari == null ? "???" : salari));
                System.out.println("Comissió: " +  (comissio == null ? "???" : comissio));
                System.out.println("Departament: " + dept);
            }
            if (!trobat) {
                System.out.println("No hi ha cap empleat!");
            }
            rs.close();
        } catch (SQLException ex) {
            Logger.getLogger(ProvesEmpresa.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}
