/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package org.milaifontanals;

import java.io.FileInputStream;
import java.sql.*;
import java.util.Properties;

/**
 *
 * @author Usuari
 */
public class CpJdbcEmpresa {

    /**
     * Constructor que crea l'objecte capa de persistència, usant un fitxer de
     * configuració de nom empresaConfigJdbc.properties
     */
    public CpJdbcEmpresa() throws CpJdbcEmpresaException {
        this("empresaConfigJdbc.properties");
    }

    /**
     * Constructor que crea l'objecte capa de persistència, usant un fitxer de
     * configuració de nom passat per paràmetre o, si és null o cadena buida, de nom
     * empresaConfigJdbc.properties
     */
    public CpJdbcEmpresa(String nomFitxerPropietats) throws CpJdbcEmpresaException {
        if (nomFitxerPropietats==null || nomFitxerPropietats.equals("")) {
            nomFitxerPropietats = "empresaConfigJdbc.properties";
        }
        Properties p = new Properties();
        try {
            p.load(new FileInputStream(nomFitxerPropietats));
        } catch (Exception ex) {
            throw new CpJdbcEmpresaException("Error en carregar fitxer de propietats "+nomFitxerPropietats,ex);
        }

        String url, user, pwd;
        url = p.getProperty("url");
        user = p.getProperty("user");
        pwd = p.getProperty("pwd");
        // Es podria fer comprovacions de NOT NULL

        Connection c = null;
        try {
            c = DriverManager.getConnection(url, user, pwd);
        } catch (SQLException ex) {
            throw new CpJdbcEmpresaException("Error en establir connexió",ex);
        }        
        try {
            c.setAutoCommit(false);
        } catch (SQLException ex) {
            throw new CpJdbcEmpresaException("Error en desactivar autocommit",ex);
        }        
    }
    

    /**
     * Comprova si existeix un departament determinat
     *
     * @param codi: Codi del departament
     * @return cert si existeix i fals en cas contrari
     */
    public boolean existDepartament(int codi) {
        return false;
    }
}
