/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package org.milaifontanals;

import java.sql.*;

/**
 *
 * @author Usuari
 */
public class ProgramaProva {

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Error en posar en marxa el programa.");
            System.out.println("Necessita 3 paràmetres: URL, usuari i empresa");
            System.exit(1);
        }
        Connection c = null;
        try {
            c = DriverManager.getConnection(args[0], args[1], args[2]);
            System.out.println("Connexió establerta!");
            c.setAutoCommit(false);

            PreparedStatement ps = c.prepareStatement("select emp_no, cognom from emp where emp_no < ? order by emp_no desc");
            ps.setInt(1, 7500);
            ResultSet rs7500 = ps.executeQuery();
            if (rs7500.next()) {
                System.out.println("Primer empleat trobat via rs7500: " + rs7500.getInt("emp_no"));
            }
            ps.setInt(1, 9999);
            ResultSet rs9999 = ps.executeQuery();
            if (rs9999.next()) {
                System.out.println("Primer empleat via rs9999: " + rs9999.getInt("emp_no"));
            }
            System.out.println("Volem veure el cognom de l'empleat apuntat per rs7500");
            try {
                System.out.println("\tCognom: " + rs7500.getString("cognom"));
            } catch (SQLException ex) {
                System.out.println("Error en intentar accedir al cognom: " + ex.getMessage());
            }
            System.out.println("Fixem-nos en l'estat obert/tancat dels 2 ResultSet:");
            System.out.println("\trs7500 tancat? " + rs7500.isClosed());
            System.out.println("\trs9999 tancat? " + rs9999.isClosed());

        } catch (SQLException ex) {
            System.out.println("Error: " + ex.getMessage());
        } finally {
            try {
                if (c != null) {
                    c.close();
                    System.out.println("Connexió tancada!");
                }
            } catch (SQLException ex) {
                System.out.println("Error en tancar la connexió: " + ex.getMessage());
            }
        }
    }
}
