package org.milaifontanals.inter;

/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Interface.java to edit this template
 */


import org.milaifontanals.empresa.Departament;
import org.milaifontanals.empresa.Empleat;

/**
 *
 * @author Usuari
 */
public interface InterCpEmpresa {

    void desferCanvis() throws InterCpEmpresaException;

    /**
     * Informa de l'existència de departament amb el codi indicat per paràmetre.
     *
     * @param codi Codi del departament pel que es vol comprovar existència
     * @return Valor booleà que indica l'existència del departament indicat
     * @throws InterCpEmpresaException si es produeix algun error (introduir un
     * codi inadequat genera també aquesta excepció)
     */
    boolean existeixDepartament(int codi) throws InterCpEmpresaException;

    /**
     * Informa de l'existència d'empleat amb el codi indicat per paràmetre.
     *
     * @param codi Codi de l'empleat pel que es vol comprovar existència
     * @return Valor booleà que indica l'existència del departament indicat
     * @throws InterCpEmpresaException si es produeix algun error (introduir un
     * codi inadequat genera també aquesta excepció)
     */
    boolean existeixEmpleat(int codi) throws InterCpEmpresaException;

    /**
     * Insereix objecte departament.
     *
     * @param d Departament a inserir
     * @throws InterCpEmpresaException si es produeix algun error.
     */
    void inserirDepartament(Departament d) throws InterCpEmpresaException;

    /**
     * Insereix objecte Empleat.
     *
     * @param e Empleat a inserir
     * @throws InterCpEmpresaException si es produeix algun error. Si l'empleat
     * té cap i/ol departament que no són a la BD, genera error.
     */
    void inserirEmpleat(Empleat e) throws InterCpEmpresaException;

    /**
     * Recupera objecte departament amb el codi indicat per paràmetre.
     *
     * @param codi Codi del departament que es vol recuperar
     * @return Objecte Departament si existeix o null en cas contrari
     * @throws InterCpEmpresaException si es produeix algun error (introduir un
     * codi inadequat genera també aquesta excepció)
     */
    Departament obtenirDepartament(int codi) throws InterCpEmpresaException;

    /**
     * Recupera objecte Empleat amb el codi indicat per paràmetre.
     *
     * @param codi Codi de l'empleat que es vol recuperar
     * @return Objecte Empleat si existeix o null en cas contrari
     * @throws InterCpEmpresaException si es produeix algun error (introduir un
     * codi inadequat genera també aquesta excepció)
     */
    Empleat obtenirEmpleat(int codi) throws InterCpEmpresaException;

    void tancarCapa() throws InterCpEmpresaException;

    void validarCanvis() throws InterCpEmpresaException;
    
}
