/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 * Click nbfs://nbhost/SystemFileSystem/Templates/Classes/Class.java to edit this template
 */
package org.milaifontanals.txt;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import org.milaifontanals.empresa.Departament;
import org.milaifontanals.empresa.Empleat;
import org.milaifontanals.inter.InterCpEmpresa;
import org.milaifontanals.inter.InterCpEmpresaException;

/**
 * Capa de persistència per la gestió dels departaments i empleats de l'empresa,
 * segons el model definit en el projecte Empresa en fitxers de text:<BR>
 * -	Fitxer de text pels departaments, amb una seqüència de:<BR>
 * Línia amb el codi<BR>
 * Línia amb el nom<BR>
 * Línia amb la localitat (buida si no es coneix)<BR>
 * -	Fitxer de text pels empleats, amb una seqüència de:<BR>
 * Línia amb el codi<BR>
 * Línia amb el cognom<BR>
 * Línia amb l’ofici (buida si no es coneix)<BR>
 * Línia amb el codi d’empleat del cap (buida si no es coneix)<BR>
 * Línia amb la data d’alta (buida si no es coneix)<BR>
 * Línia amb el salari (buida si no es coneix)<BR>
 * Línia amb la comissió (buida si no es coneix)<BR>
 * Línia amb el codi de departament (buida si no es coneix)<BR>
 *
 * L'aplicació que usi la capa de persistència ha de disposar d'un fitxer de
 * propietats (veure documentació dels constructors) accessible via load(Reader)
 * amb les propietats següents:<BR>
 * fDepartament: Ruta completa del fitxer on hi ha els departaments<BR>
 * fEmpleat: Ruta completa del fitxer on hi ha els empleats<BR>
 *
 * @author Isidre Guixà
 */
public class CpTxtLinEmpresa implements InterCpEmpresa {

    // Variables per tenir carregades les dades en memòria
    private HashMap<Integer, Departament> hmDept = new HashMap();
    private HashMap<Integer, Empleat> hmEmp = new HashMap();

    // Variables de treball
    private SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");

    /**
     * Constructor que crea l'objecte capa de persistència, usant un fitxer de
     * configuració de nom empresaConfigTxtLin.properties
     *
     * @throws InterCpEmpresaException si hi ha algun problema en el fitxer de
     * configuració o en l'accés a les dades
     */
    public CpTxtLinEmpresa() throws InterCpEmpresaException {
        this("empresaConfigTxtLin.properties");
    }

    /**
     * Constructor que crea l'objecte capa de persistència, usant un fitxer de
     * configuració de nom passat per paràmetre i, en cas de ser null o buit,
     * cerca fitxer de nom empresaConfigTxtLin.properties
     *
     * @param nomFitxerPropietats
     * @throws InterCpEmpresaException si hi ha algun problema en el fitxer de
     * configuració o en l'accés a les dades
     */
    public CpTxtLinEmpresa(String nomFitxerPropietats) throws InterCpEmpresaException {
        if (nomFitxerPropietats == null || nomFitxerPropietats.equals("")) {
            nomFitxerPropietats = "empresaConfigJdbc.properties";
        }
        Properties p = new Properties();
        try {
            p.load(new FileInputStream(nomFitxerPropietats));
        } catch (Exception ex) {
            throw new InterCpEmpresaException("Error en carregar fitxer de propietats " + nomFitxerPropietats, ex);
        }

        String fitxerDept = p.getProperty("fDepartament");
        String fitxerEmp = p.getProperty("fEmpleat");

        RandomAccessFile raf = null;
        // C+arrega dels departaments
        try {
            raf = new RandomAccessFile(fitxerDept, "r");
            while (true) {
                String aux = raf.readLine();
                if (aux == null) {
                    break;
                }
                int codi = Integer.parseInt(aux);
                String nom = raf.readLine();
                String loc = raf.readLine();
                if (loc.equals("")) {
                    loc = null;
                }
                hmDept.put(codi, new Departament(codi, nom, loc));
            }
        } catch (IOException ex) {
            throw new InterCpEmpresaException("Error en carregar dades de departament", ex);
        } finally {
            if (raf != null) {
                try {
                    raf.close();
                } catch (IOException ex) {
                }
            }
        }
        // Càrrega dels empleats. Primer carregarem tots els empleats deixant-los sense "cap".
        // Guardarem en dadesCaps la relació dels codis d'empleat que tenen cap amb el codi del seu cap
        HashMap<Integer, Integer> dadesCaps = new HashMap();
        try {
            raf = new RandomAccessFile(fitxerEmp, "r");
            while (true) {
                String aux = raf.readLine();
                if (aux == null) {
                    break;
                }
                int codi = Integer.parseInt(aux);
                String cognom = raf.readLine();
                String ofici = raf.readLine();
                if (ofici.equals("")){
                    ofici = null;
                }
                String auxCap = raf.readLine();
                if (!auxCap.equals("")) {
                    dadesCaps.put(codi, Integer.parseInt(auxCap));
                }
                String auxData = raf.readLine();
                GregorianCalendar data = null;
                if (!auxData.equals("")) {
                    data = new GregorianCalendar();
                    data.setTime(sdf.parse(auxData));
                }
                Double salari = null;
                String auxSalari = raf.readLine();
                if (!auxSalari.equals("")) {
                    salari = Double.parseDouble(auxSalari);
                }
                Double comissio = null;
                String auxComissio = raf.readLine();
                if (!auxComissio.equals("")) {
                    comissio = Double.parseDouble(auxComissio);
                }
                Departament dept = null;
                String auxDept = raf.readLine();
                if (!auxDept.equals("")) {
                    dept = hmDept.get(Integer.parseInt(auxDept));
                    if (dept == null) {
                        throw new InterCpEmpresaException("Empleat " + codi + " té assignat departament " + auxDept + " inexistent");
                    }
                }
                hmEmp.put(codi, new Empleat(codi, cognom, ofici,
                        data, salari, comissio,
                        null, dept));
            }
            // Ara ens cal assignar els caps a aquells empleats que tenen cap.
            // Havíem guardat la informació dins dadesCaps.
            Set<Integer> codisEmpAmbCap = dadesCaps.keySet();
            for (Integer codi : codisEmpAmbCap) {
                Empleat empleatQueTeCap = hmEmp.get(codi);
                Integer codiDelSeuCap = dadesCaps.get(codi);
                empleatQueTeCap.setCap(hmEmp.get(codiDelSeuCap));
            }
        } catch (IOException | ParseException ex) {
            throw new InterCpEmpresaException("Error en carregar dades de departament", ex);
        }

    }

    @Override
    public void desferCanvis() throws InterCpEmpresaException {
        throw new UnsupportedOperationException("Not supported yet."); // Generated from nbfs://nbhost/SystemFileSystem/Templates/Classes/Code/GeneratedMethodBody
    }

    @Override
    public boolean existeixDepartament(int codi) throws InterCpEmpresaException {
        throw new UnsupportedOperationException("Not supported yet."); // Generated from nbfs://nbhost/SystemFileSystem/Templates/Classes/Code/GeneratedMethodBody
    }

    @Override
    public boolean existeixEmpleat(int codi) throws InterCpEmpresaException {
        throw new UnsupportedOperationException("Not supported yet."); // Generated from nbfs://nbhost/SystemFileSystem/Templates/Classes/Code/GeneratedMethodBody
    }

    @Override
    public void inserirDepartament(Departament d) throws InterCpEmpresaException {
        throw new UnsupportedOperationException("Not supported yet."); // Generated from nbfs://nbhost/SystemFileSystem/Templates/Classes/Code/GeneratedMethodBody
    }

    @Override
    public void inserirEmpleat(Empleat e) throws InterCpEmpresaException {
        throw new UnsupportedOperationException("Not supported yet."); // Generated from nbfs://nbhost/SystemFileSystem/Templates/Classes/Code/GeneratedMethodBody
    }

    @Override
    public Departament obtenirDepartament(int codi) throws InterCpEmpresaException {
        throw new UnsupportedOperationException("Not supported yet."); // Generated from nbfs://nbhost/SystemFileSystem/Templates/Classes/Code/GeneratedMethodBody
    }

    @Override
    public Empleat obtenirEmpleat(int codi) throws InterCpEmpresaException {
        throw new UnsupportedOperationException("Not supported yet."); // Generated from nbfs://nbhost/SystemFileSystem/Templates/Classes/Code/GeneratedMethodBody
    }

    @Override
    public void tancarCapa() throws InterCpEmpresaException {
        throw new UnsupportedOperationException("Not supported yet."); // Generated from nbfs://nbhost/SystemFileSystem/Templates/Classes/Code/GeneratedMethodBody
    }

    @Override
    public void validarCanvis() throws InterCpEmpresaException {
        throw new UnsupportedOperationException("Not supported yet."); // Generated from nbfs://nbhost/SystemFileSystem/Templates/Classes/Code/GeneratedMethodBody
    }

}
