#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void netejar_buffer_teclat();
// Noms es pot invocar si es t seguretat de que en el buffer del teclat
// ha quedat algun contingut.

int llegirTextAmbSeguretat(char *cadena, int mida);
// mida s la capacitat total de la cadena, amb el \0 incorporat
// Retorna: 0 si s'ha sobrepassat la mida de la cadena o no s'ha entrat res
//			1: s'ha llegit un cadena amb strlen<=mida-1
// En qualsevol cas, el buffer del teclat queda buit.

int main()
{
    int x = 10;
    char cad[10];
    int y = 20;

	printf("x: %d\n", x);
    printf("y: %d\n", y);
    printf("Introdueixi cadena, de com a molt %lld carcters: ",sizeof(cad)-1);
	if (llegirTextAmbSeguretat(cad, sizeof(cad))) {
		printf("Correcte!\n");
	}
	else {
		printf("Error!\n");
	}
	printf("Cadena llegida: %s\n", cad);
	printf("Llargada: %d\n", strlen(cad));
	printf("x: %d\n", x);
    printf("y: %d\n", y);
    printf("Introdueixi nou valor per x: ");
    scanf("%d",&x);
    netejar_buffer_teclat();
    printf("Introdueixi nou valor per y: ");
    scanf("%d",&y);
    netejar_buffer_teclat();
	printf("x: %d\n", x);
    printf("y: %d\n", y);

    return 0;
}

int llegirTextAmbSeguretat(char *cadena, int mida) {
    if (mida<=0) return 0;
	if (fgets(cadena, mida, stdin) == NULL) {
		// Aix pot passar quan es redirecciona stdin des d'un fitxer i s'ha
		// arribat al final del fitxer o quan l'usuari prem CTRL-Z (Windows)
		// o CTRL-D (Linux/MacOS)
		cadena[0] = '\0';
		return 0;  // No hi ha res a llegir
	}

	size_t len = strlen(cadena);

	if (len > 0 && cadena[len - 1] == '\n') {
		// L'usuari ha escrit menys de mida-1 carcters. Canviem \n per \0
		cadena[len - 1] = '\0';
		return 1;  // cert: buffer net
	}
	else {
		// No hi ha '\n' => vol dir que hi ha carcters pendents en el buffer
		// Si noms ha quedat \n, no s problema:
		int c = getchar();
		if (c == '\n') return 1;
		// Han quedat ms carcters - Buidem el buffer del teclat
		while ((c = getchar()) != '\n' && c != EOF);
		cadena[0] = '\0';
		return 0;  // fals: hi havia residus
	}
}

void netejar_buffer_teclat() {
    int c;
    while ((c = getchar()) != '\n' && c != EOF);
}

