#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void netejar_buffer_teclat();
// Només es pot invocar si es té seguretat de que en el buffer del teclat
// ha quedat algun contingut.

int llegirTextAmbSeguretat();
// mida és la capacitat total de la cadena, amb el \0 incorporat
// Retorna: 0 si s'ha sobrepassat la mida de la cadena o no s'ha entrat res
//			1: s'ha llegit un cadena amb strlen<=mida-1
// En qualsevol cas, el buffer del teclat queda buit.

int main()
{
    int x = 10;
    char cad[10];
    int y = 20;

	printf("x: %d\n", x);
    printf("y: %d\n", y);
    printf("Introdueixi cadena, de com a molt %lld caràcters: ",sizeof(cad)-1);
	if (llegirTextAmbSeguretat(cad, sizeof(cad))) {
		printf("Correcte!\n");
	}
	else {
		printf("Error!\n");
	}
	printf("Cadena llegida: %s\n", cad);
	printf("Llargada: %d\n", strlen(cad));
	printf("x: %d\n", x);
    printf("y: %d\n", y);
    printf("Introdueixi nou valor per x: ");
    scanf("%d",&x);
    netejar_buffer_teclat();
    printf("Introdueixi nou valor per y: ");
    scanf("%d",&y);
    netejar_buffer_teclat();
	printf("x: %d\n", x);
    printf("y: %d\n", y);

    return 0;
}

int llegirTextAmbSeguretat(char *cadena, int mida) {
    if (mida<=0) return 0;
    if (mida==1) { // Només hi ha espai per '\0'
        // Només seria vàlida l'entrada '\n';
        // LLegim 1r caràcter i comprovem si és '\n'
        int c = getchar();
		if (c == '\n') return 1;
		// Han quedat més caràcters - Buidem el buffer del teclat
		while ((c = getchar()) != '\n' && c != EOF);
		cadena[0] = '\0';
		return 0;  // fals: hi havia residus
    }

    cadena[0]='\n'; // Per poder detectar si l'usuari només prem Enter (cadena buida)
    // ja que en aquest cas, la crida scanf_s següent no recull res
    int resultat = scanf_s("%[^\n]", cadena, mida);

    if (resultat == EOF) {
		// Això pot passar quan es redirecciona stdin des d'un fitxer i s'ha
		// arribat al final del fitxer o quan l'usuari prem CTRL-Z (Windows)
		// o CTRL-D (Linux/MacOS)
        cadena[0]='\0';
        return 0;  // No hi ha res a llegir
    }

    if (cadena[0]=='\n') {
        // L’usuari només ha premut Enter
        cadena[0] = '\0';
        return 1;
    }

    if (resultat==0) {
        // No ha premut només Enter i scanf_s no ha llegit => Error!!!
        cadena[0] = '\0';
        // Buidem els residus
        int c;
        while ((c = getchar()) != '\n' && c != EOF);
        return 0;  // hi havia residus
    }
}

void netejar_buffer_teclat() {
    int c;
    while ((c = getchar()) != '\n' && c != EOF);
}

