﻿#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void netejar_buffer_teclat();

int llegirTextAmbSeguretat(char* cadena, int mida);  
// mida és la capacitat total de la cadena, amb el \0 incorporat
// Retorna: 0 si s'ha sobrepassat la mida de la cadena o no s'ha entrat res
//			1: s'ha llegit un cadena amb strlen<=mida-1
// En qualsevol cas, el buffer del teclat queda buit.

int main()
{
    int x = 10;
    char cad[5];
    int y = 20;

    printf("Introdueixi cadena, de com a molt %lld caràcters: ", sizeof(cad) - 1);
    if (llegirTextAmbSeguretat(cad, sizeof(cad))) {
        printf("Correcte!\n");
    }
    else {
        printf("Error!\n");
    }
    printf("Cadena llegida: %s\n", cad);
    printf("x: %d\n", x);
    printf("y: %d\n", y);

    return 0;
}

int llegirTextAmbSeguretat(char* cadena, int mida) {
    
    int resultat = scanf_s("%[^\n]", cadena, mida);

    if (resultat == EOF) {
        // Això pot passar quan es redirecciona stdin des d'un fitxer i s'ha
        // arribat al final del fitxer o quan l'usuari prem CTRL-Z (Windows)
        // o CTRL-D (Linux/MacOS)
        cadena[0] = '\0';
        return 0;  // No hi ha res a llegir
    }

    if (resultat == 0) {
        // L’usuari només ha premut Enter
        cadena[0] = '\0';
        getchar(); // Consumim el '\n'
        return 1;
    }

    // Hem llegit alguna cosa → ara comprovem si quedaven residus
    int c = getchar();  // llegim el primer caràcter després del text
    if (c == '\n' || c == EOF) {
        return 1;  // buffer net
    }
    else {
        // Hi havia més caràcters al buffer → netegem fins al salt de línia
        while ((c = getchar()) != '\n' && c != EOF);
        return 0;  // hi havia residus
    }
}

void netejar_buffer_teclat() {
    int c;
    while ((c = getchar()) != '\n' && c != EOF);
}

