#include "utils.h"

void netejar_buffer_teclat() {
    int c;
    while ((c=getchar())!='\n' && c!=EOF);
}

int llegirTextAmbSeguretat(char* cadena, int mida) {
    if (mida<=0) return 0;
	if (fgets(cadena, mida, stdin) == NULL) {
		// Aix pot passar quan es redirecciona stdin des d'un fitxer i s'ha
		// arribat al final del fitxer o quan l'usuari prem CTRL-Z (Windows)
		// o CTRL-D (Linux/MacOS)
		cadena[0] = '\0';
		return 0;  // No hi ha res a llegir
	}

	size_t len = strlen(cadena);

	if (len > 0 && cadena[len - 1] == '\n') {
		// L'usuari ha escrit menys de mida-1 carcters. Canviem \n per \0
		cadena[len - 1] = '\0';
		return 1;  // cert: buffer net
	}
	else {
		// No hi ha '\n' => vol dir que hi ha carcters pendents en el buffer
		// Si noms ha quedat \n, no s problema:
		int c = getchar();
		if (c == '\n') return 1;
		// Han quedat ms carcters - Buidem el buffer del teclat
		while ((c = getchar()) != '\n' && c != EOF);
		cadena[0] = '\0';
		return 0;  // fals: hi havia residus
	}
}

int llegirTextAmbSeguretatMSVC(char* cadena, int mida) {
    if (mida<=0) return 0;
    if (mida==1) { // Noms hi ha espai per '\0'
        // Noms seria vlida l'entrada '\n';
        // LLegim 1r carcter i comprovem si s '\n'
        int c = getchar();
		if (c == '\n') return 1;
		// Han quedat ms carcters - Buidem el buffer del teclat
		while ((c = getchar()) != '\n' && c != EOF);
		cadena[0] = '\0';
		return 0;  // fals: hi havia residus
    }

    cadena[0]='\n'; // Per poder detectar si l'usuari noms prem Enter (cadena buida)
    // ja que en aquest cas, la crida scanf_s segent no recull res
    int resultat = scanf_s("%[^\n]", cadena, mida);

    if (resultat == EOF) {
		// Aix pot passar quan es redirecciona stdin des d'un fitxer i s'ha
		// arribat al final del fitxer o quan l'usuari prem CTRL-Z (Windows)
		// o CTRL-D (Linux/MacOS)
        cadena[0]='\0';
        return 0;  // No hi ha res a llegir
    }

    if (cadena[0]=='\n') {
        // Lusuari noms ha premut Enter
        cadena[0] = '\0';
        return 1;
    }

    if (resultat==0) {
        // No ha premut noms Enter i scanf_s no ha llegit => Error!!!
        cadena[0] = '\0';
        // Buidem els residus
        int c;
        while ((c = getchar()) != '\n' && c != EOF);
        return 0;  // hi havia residus
    }
    return 0;
}

