#include <stdio.h>

/**
Funci on a i b sn parmetres per valor
En executar la funci, el S.O. crea "a" i "b"
com a cpia dels valors proporcionats en la crida
*/
int suma (int a, int b) {
    return a+b;
}

/**
Acci on a, b i resultat sn parmetres per valor
En executar l'acci, el S.O. crea "a", "b" i "resultat"
com a cpia dels valors proporcionats en la crida
Encara que "resultat" es modifiqui dins l'acci, en
finalitzar l'acci no queda modificada la corresponent
variable en la crida.
Per tant, aquesta versi de "suma" no ens serveix
si pretenem que l'argument que es passi com a 3 parmetre
quedi modificat amb el resultat de la suma.
*/
void suma_KO (int a, int b, int resultat) {
    printf ("Dins suma - Abans de sumar - Resultat = %d\n",resultat);
    resultat = a + b;
    printf ("Dins suma - Desprs de sumar - Resultat = %d\n",resultat);
}

/**
Versi correcta vlida NOMS en CPP, usant referncies.
En aquest cas "a", "b" i "resultat" sn referncies a les variables
que es passen com arguments en efectuar la crida.
Qualsevol canvi que s'efectu en aquestes referncies,
s'est efectuant en les variables passades com arguments.
Les referncies "a" i "b" s'han declarat constants per evitar
que el seu valor pugui canviar dins la funci (aix t el mateix
efecte que un pas per valor).
En treballar amb referncies, en executar la crida NO dupliquem
variables en memria i, per tant, s ms eficient que el pas per valor
i el pas "via punter" de la versi suma_OK2 segent
*/
void suma_OK1 (const int &a, const int &b, int &resultat) {
    resultat = a + b;
}

/**
Versi correcta vlida en C i CPP, usant "punters" quan es vol
que alguna de les variables argument en la crida sigui modificada
dins la funci/acci.
En aquest cas "a" i "b" son parmetres per valor, que en executar
l'acci sn creades i inicialitzades amb els valors de la crida.
I "resultat" s un punter per guardar l'adrea d'un enter i, en cridar-lo
se li ha de passar l'adrea de la variable que ha de quedar modificada.
*/
void suma_OK2 (int a, int b, int *resultat) {
    *resultat = a + b;
}

int main() {
    int x = 10, y = 20;

    printf("Prova de la funci 'suma'\n");
    int r1 = suma (x, y);
    printf ("%d + %d = %d\n\n", x, y, r1);

    printf("Prova de la funci 'suma_KO'\n");
    int r2 = -1;
    suma_KO (x, y, r2);
    printf ("%d + %d = %d\n\n", x, y, r2);

    printf("Prova de la funci 'suma_OK1'\n");
    int r3 = -1;
    suma_OK1 (x, y, r3);
    printf ("%d + %d = %d\n\n", x, y, r3);

    printf("Prova de la funci 'suma_OK2'\n");
    int r4 = -1;
    suma_OK2 (x, y, &r4);
    printf ("%d + %d = %d\n\n", x, y, r4);

}
