#include <stdio.h>
#include <stdlib.h>

int main()
{
    int a = 10;
    float x = 11.11F;
    printf("Valor que cont a = %d\n", a);
    printf("Adrea de memria on s a = %p\n", &a); // &nomVariable per conixer la seva adrea
    printf("Valor que cont x = %g\n", x);
    printf("Adrea de memria on s x = %p\n", &x);
    // Les adrees de memria (punters a memria) es poden guardar en variables de tipus punter
    // Per guardar l'adrea d'una variable int, declararem:
    int *pint;  // Cont valor "basura"
    // Es poden inicialitzar a NULL (molt-molt-molt aconsellable)
    // El nom de la variable punter s pint i la nomenclatura int * s per a declarar-la
    pint = NULL;    // No pas: *pint = NULL.
    // Per guardar l'adrea d'una variable float, declararem:
    float *pfloat = NULL; // En aquest cas hem inicialitzat a NULL en el moment de declaraci

    // Abans de treballar amb una variable punter, cal que contingui una adrea correcta
    // Per exemple:
    pint = &a;      // pint cont l'adrea on s a
    pfloat = &x;    // pfloat cont l'adrea on s x

    // El segent, no compila, per qu no coincideix tipus del punter amb variable apuntada:
    //pint = &x;
    //pfloat = &a;
    // Es pot "forar" a guardar una adrea a una variable d'un tipus en un punter declarat
    // per un altre tipus, per es DESACONSELLA totalment. Per fer aix, punters genrics del final.

    // Podem consultar els valors d'a/x, usant *nomPunter
    printf("\n");
    printf("Valor que cont a = %d\n", *pint);
    printf("Adrea de memria on s a = %p\n", pint); // &nomVariable per conixer la seva adrea
    printf("Valor que cont x = %g\n", *pfloat);
    printf("Adrea de memria on s x = %p\n", pfloat);

    // Els punters vistos fins ara (pint i pfloat) es poden usar per apuntar a altres variables
    int b = 20;
    pint = &b;  // pint ja no apunta "a". Ha passat a apuntar a "b"
    float y = 22.22F;
    pfloat = &y;    // pfloat ja no apunta "x". Ha passat a apuntar a "y"
    printf("\nDesprs d'haver canviat el contingut dels punters:");
    printf("Valor existent all on apunta pint = %d\n", *pint);
    printf("Adrea de memria de pint = %p\n", pint); // &nomVariable per conixer la seva adrea
    printf("Valor existent all on apunta pfloat = %g\n", *pfloat);
    printf("Adrea de memria de pfloat = %p\n", pfloat);

    // Els punters vistos fins ara es poden usar per canviar el valor de la variable apuntada:
    *pint = 30;
    *pfloat = 33.33F;
    printf("\nDesprs d'haver canviat el valor de les variables apuntades pels punters:");
    printf("Valor existent all on apunta pint = %d\n", *pint);
    printf("Valor existent all on apunta pfloat = %g\n", *pfloat);
    printf("Valor que cont b = %d\n", b);
    printf("Valor que cont y = %g\n", y);

    // Punters constants:
    // - Obligatori inicialitzar-los en el moment de declarar-los
    // - No pot canviar el seu contingut (adrea que contenen)
    // - S'usa partcula const acompanyant el nom del punter
    int *const pintconstant = &a;   // S'ha d'inicialitzar quan es crea i no pot canviar!
    //pintconstant = &b;   // No compila!

    // Punters a dades constants:
    // - A travs d'ells no es pot canviar el valor de la variable apuntada
    // - S'usa partcula const abans o desprs del nom del tipus
    const int *pintAconstant = &a;
    //*pintAconstant = 40;    // No compila!
    float const *pfloatAConstant = &x;
    //*pfloatAConstant = 44.44F;  // No compila!

    // Podem tenir punters constants a dades constants!
    const int *const pintConstantAContant;

    // Punter genrics:
    // - Es declaren sense indicar el tipus de la variable apuntada (void *)
    // - Poden guardar adreces de qualsevol tipus de variable
    // - Per accedir al contingut de la variable apuntada, cal indicar el tipus via (cast)
    //   En aquest cas, C/C++ fa cas del tipus que s'indica per accedir al contingut
    void *pgeneric = NULL;
    printf("\n");
    pgeneric = &a;
    printf ("Valor de variable apuntada per pgeneric (a): %d\n",*(int *)pgeneric);
    pgeneric = &x;
    printf ("Valor de variable apuntada per pgeneric (x): %g\n",*(float *)pgeneric);

    return 0;
}
